% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date.R
\name{date_}
\alias{date_}
\alias{date_bounded}
\alias{date_left_bounded}
\alias{date_right_bounded}
\title{Date generators}
\usage{
date_(len = 1L, frac_na = 0)

date_bounded(left, right, len = 1L, frac_na = 0)

date_left_bounded(left, len = 1L, frac_na = 0)

date_right_bounded(right, len = 1L, frac_na = 0)
}
\arguments{
\item{len}{Length of the generated vectors. If \code{len} is a
single number all vectors will have this length. If
\code{len} is a numeric vector of length 2 it will produce
vectors with lengths between a minimum and maximum,
inclusive. For example \code{len = c(1L, 10L)} would produce
vectors with lengths between 1 and 10.}

\item{frac_na}{The approximate fraction of \code{NA} values to
be included in the vector. A fraction of 0, the default,
will include no \code{NA} values. A fraction of 0.5 would
include around 50\% \code{NA} values.}

\item{left}{The minimum possible value for generated
numbers, inclusive.}

\item{right}{The maximum possible value for generated
numbers, inclusive.}
}
\value{
A \code{hedgehog.internal.gen} generator
}
\description{
A set of generators for date vectors.
}
\examples{
date_() |> show_example()
date_bounded(
  left = as.Date("2020-01-01"),
  right = as.Date("2020-01-10")
) |> show_example()
date_(len = 10L, frac_na = 0.5) |> show_example()
}
