% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other.R
\name{from_hedgehog}
\alias{from_hedgehog}
\title{Convert a hedgehog generator to a quickcheck generator}
\usage{
from_hedgehog(generator)
}
\arguments{
\item{generator}{A \code{hedgehog.internal.gen} object.}
}
\value{
A \code{quickcheck_generator} object.
}
\description{
Convert a hedgehog generator to a quickcheck generator
}
\examples{
is_even <-
  \(a) a \%\% 2L == 0L

gen_powers_of_two <-
  hedgehog::gen.element(1:10) |> hedgehog::gen.with(\(a) 2 ^ a)

for_all(
  a = from_hedgehog(gen_powers_of_two),
  property = \(a) is_even(a) |> testthat::expect_true()
)
}
