% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filename.R
\name{fAddDate}
\alias{fAddDate}
\title{Append date to filename}
\usage{
fAddDate(...)
}
\arguments{
\item{...}{file name or path to concat}
}
\value{
file name with the current date added as suffix
}
\description{
Add today's date to the filename
}
\details{
The present function enables users to add the current date to the file name,
facilitating the straightforward saving of files with their respective dates.
It accepts different file paths and names as arguments, as demonstrated
in the example section. This functionality simplifies the process of associating
a file's creation date with its name, aiding users in recalling when a file was
saved. Moreover, it serves as a preventive measure against unintentional
overwriting of files created on different dates.
}
\examples{

# Task 1
fAddDate("path1/","path2/filepre","filemid","fileend.png")

# Task 2
fAddDate(c("path1/","path2/"),"filepre","filemid","fileend.png")

# Task 3
fAddDate("one_file_name_fileend.pdf")

# Task 4
fAddDate(c("path1/","path2/"),"filepre","filemid",c("fileend.png",".pdf"))


}
