% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0.7_combo_func1.R
\name{strsplit.bool}
\alias{strsplit.bool}
\title{Split a string of values and return as boolean vector}
\usage{
strsplit.bool(
  x,
  split,
  fixed = FALSE,
  perl = FALSE,
  useBytes = FALSE,
  type = 2
)
}
\arguments{
\item{x}{character vector, each element of which is to be split. Other inputs, including a factor, will give an error.}

\item{split}{character vector}

\item{fixed}{logical. If TRUE match split exactly, otherwise use regular expressions. Has priority over perl.}

\item{perl}{logical. Should Perl-compatible regexps be used?}

\item{useBytes}{logical. If TRUE the matching is done byte-by-byte rather than character-by-character, and inputs with marked encodings are not converted.}

\item{type}{type of return, see the as.boolean function for more info}
}
\value{
boolean values based on split string
}
\description{
The purpose of this function is combine the functionality of
\strong{strsplit}, \strong{unlist} and \strong{as.logical}, which are often used together.\cr\cr
}
\details{
Given a sting, split by a separator into boolean
}
\examples{
# string of numbers
num.01 = "0 1 0 0 1 0 1 T F TRUE FALSE t f"

# split a string of numbers and return as boolean 1/0
strsplit.bool(num.01, split = " ", type = 3)

# split a string of numbers and return as boolean TRUE/FALSE
strsplit.bool(num.01, split = " ", type = 2)

# split a string of numbers and return as boolean Yes/No
strsplit.bool(num.01, split = " ", type = 1)


# string of numbers
num.02 = "0abc1abc0abc0abc1abc0abc1abcTabcFabcTRUEabcFALSEabcf"

# split a string of numbers and return as boolean 1/0
strsplit.bool(num.02, split = "abc", type = 3)

# split a string of numbers and return as boolean TRUE/FALSE
strsplit.bool(num.02, split = " ", type = 2)

# split a string of numbers and return as boolean Yes/No
strsplit.bool(num.02, split = " ", type = 1)

}
