% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{subset-trait_categories}
\alias{subset-trait_categories}
\alias{[,trait_categories,missing,missing,missing-method}
\alias{[,trait_categories,numeric,missing,missing-method}
\alias{[,trait_categories,character,missing,missing-method}
\title{Subset a trait_categories object}
\usage{
\S4method{[}{trait_categories,missing,missing,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{trait_categories,numeric,missing,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{trait_categories,character,missing,missing}(x, i, j, ..., drop = FALSE)
}
\arguments{
\item{x}{A \linkS4class{trait_categories} object.}

\item{i}{Position of the identifier or the name of the identifier itself.}

\item{j}{Not used.}

\item{...}{Additional arguments not used here.}

\item{drop}{Not used.}
}
\value{
A \linkS4class{trait_categories} object.
}
\description{
You can subset \linkS4class{trait_categories} by trait category (string) or
by position using the \code{`[`} operator.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get details about all trait categories:
all_trait_categories <- get_trait_categories(progress_bar = FALSE)

#
# Subsetting by position
#
all_trait_categories[1:5]

#
# Subsetting by trait category (character)
#
all_trait_categories['Liver enzyme measurement']
\dontshow{\}) # examplesIf}
}
\keyword{internal}
