% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qable.R
\name{qable}
\alias{qable}
\title{Qable: an extended verion of knitr::kable}
\usage{
qable(x, rgroup, rnames = rownames(x), cnames = colnames(x),
  markup = getOption("qwraps2_markup", "latex"), ...)
}
\arguments{
\item{x}{\code{matrix} or \code{data.frame} to be turned into a qable}

\item{rgroup}{a named numeric vector with the name of the row group and the
number of rows within the group.  \code{sum(rowgroup) == nrow(x)}.}

\item{rnames}{a character vector of the row names}

\item{cnames}{column names}

\item{markup}{the markup language to use, passed to the \code{format}
argument of \code{knitr::kable}.}

\item{...}{additional arguments passed to \code{knitr::kable}}
}
\value{
a character vector of the formatted numbers
}
\description{
Create a simple table via kable with row groups and rownames
similar to those of \code{hmisc::latex} or \code{htmlTable::htmlTable}.
}
\details{
\code{qable} is used as the printing method for \code{qwraps2_summary_table}
objects.  Check the vignettes for examples on building data summary tables.
}
\examples{
data(mtcars)
qable(mtcars)
qable(mtcars, markup = "markdown")

# by make
make <- sub("^(\\\\w+)\\\\s?(.*)$", "\\\\1", rownames(mtcars))
make <- c(table(make))

qable(mtcars[sort(rownames(mtcars)), ], rgroup = make)
qable(mtcars[sort(rownames(mtcars)), ], rgroup = make, markup = "markdown")

# define your own column names
qable(mtcars[sort(rownames(mtcars)), ], 
      rgroup = make, 
      cnames = toupper(colnames(mtcars)), 
      markup = "markdown")

}
\seealso{
\code{\link[knitr]{kable}}
\code{summary_table}, for
}

