% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qplot_emission_intensity.R
\name{qplot_emission_intensity}
\alias{qplot_emission_intensity}
\title{Create a quick emission intensity plot}
\usage{
qplot_emission_intensity(data)
}
\arguments{
\item{data}{A data frame. Requirements:
\itemize{
\item The structure must be like \link{sda}.
\item The column \code{sector} must have a single value (e.g. "cement").
\item (Optional) If present, the column \code{label} is used for data labels.
}}
}
\value{
An object of class "ggplot".
}
\description{
Compared to \code{\link[=plot_emission_intensity]{plot_emission_intensity()}} this function:
\itemize{
\item is restricted to plotting future as 5 years from the start year,
\item outputs formatted labels, based on emission metric column,
\item outputs a title,
\item outputs formatted axis labels.
}
}
\examples{
# `data` must meet documented "Requirements"
data <- subset(sda, sector == "cement" & region == "global")

qplot_emission_intensity(data)
}
\seealso{
plot_emission_intensity
}
