% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default_hash_fn.R
\name{default_hash_fn}
\alias{default_hash_fn}
\title{String hashes for arbitrary R objects}
\usage{
default_hash_fn(key)
}
\arguments{
\item{key}{an arbitrary R object.}
}
\value{
a character vector of length one. Hash digest of \code{key}.
}
\description{
generates string hashes for arbitrary R objects as follows.
This is the default hash function used by \code{hashset}s and \code{hashmap}s
objects.
}
\details{
If \code{key} is an atomic vector (as tested by
\code{is.atomic(key)}) of length one, \code{default_hash_fn(key)} simply
coerces the input to character. For more complex inputs, the function calls
\code{digest(key)} from the \link[digest]{digest} package.
}
\author{
Valerio Gherardi
}
