% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/hashmap.R, R/hashset.R
\name{has_key}
\alias{has_key}
\alias{\%has_key\%}
\alias{has_key.r2r_hashmap}
\alias{has_key.r2r_hashset}
\title{Key existence in hash tables}
\usage{
has_key(x, key)

x \%has_key\% key

\method{has_key}{r2r_hashmap}(x, key)

\method{has_key}{r2r_hashset}(x, key)
}
\arguments{
\item{x}{an \code{hashset} or \code{hashmap}.}

\item{key}{an arbitrary R object. Key to be checked for existence in the
hash table.}
}
\value{
\code{TRUE} or \code{FALSE}.
}
\description{
This generics are used to check whether a key exists in a given
\code{hashset} or \code{hashmap}.
}
\examples{
m <- hashmap(list("a", 1), list("b", 2))
has_key(m, "a")
m \%has_key\% "b"
}
\author{
Valerio Gherardi
}
