% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shareButton.R
\name{shareButton}
\alias{shareButton}
\title{Add social buttons to share a page}
\usage{
shareButton(
  link,
  image = NULL,
  text = NULL,
  position = c("left", "right", "inline"),
  text.color = "black",
  facebook = TRUE,
  linkedin = TRUE,
  twitter = TRUE,
  tumblr = FALSE,
  pinterest = FALSE,
  whatsapp = FALSE,
  reddit = TRUE,
  instagram = FALSE,
  blogger = FALSE,
  weibo = TRUE,
  tiktok = FALSE,
  vk = FALSE,
  telegram = FALSE,
  youtube = FALSE,
  visit.us = FALSE
)
}
\arguments{
\item{link}{the link to share on social media}

\item{image}{the image link to share on social media}

\item{text}{the text to share on social media}

\item{position}{of buttons e.g "left","right","bottom","inline"}

\item{text.color}{text color e.g black}

\item{facebook}{share on Facebook}

\item{linkedin}{share on Linkedin}

\item{twitter}{share on Twitter}

\item{tumblr}{share on Tumblr}

\item{pinterest}{share on Pinterest}

\item{whatsapp}{share on Whatsapp}

\item{reddit}{share on Reddit}

\item{instagram}{share on Instagram}

\item{blogger}{share on blogger}

\item{weibo}{share on weibo}

\item{tiktok}{share on tiktok}

\item{vk}{share on VK or VKontakte}

\item{telegram}{share on Telegram}

\item{youtube}{share on Youtube}

\item{visit.us}{share on custom link}
}
\value{
Share link button via social media platforms
}
\description{
Customize social buttons available for sharing of pages
}
\section{Examples for r2social}{

More examples and demo pages are located at this link -
\url{https://r2social.obi.obianom.com}.
}

\examples{

shareButton(link = "http://rpkg.net", position = "left")
shareButton(link = "http://obianom.com", position = "right")
shareButton(link = "http://66pharm.com", position = "inline")

}
