% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ok.R
\name{o311_ok}
\alias{o311_ok}
\title{Is open311 API ok?}
\usage{
o311_ok(error = FALSE)
}
\arguments{
\item{error}{\code{[logical]}

Whether to return a logical or the error message describing why the
API is not ok.}
}
\value{
A logical describing whether the API is reachable or not.
If \code{error = TRUE}, returns the corresponding error object if one
occurs.
}
\description{
Checks whether an open311 API mounted by \code{\link{o311_api}} is reachable
and returns a valid requests response.
}
\examples{
\donttest{
# check if Bonn API is reachable
o311_api("Bonn")
o311_ok()

# check if Helsinki API is reachable - fails
o311_add_endpoint(
  name = "Helsinki",
  root = "asiointi.hel.fi/palautews/rest/v1/"
)

o311_api("Helsinki")
o311_ok()

# return error message
try(o311_ok(error = TRUE))

# reset endpoints database
o311_reset_endpoints()
}
}
