SS_changepars <-
function(
         dir="C:/myfiles/mymodels/myrun/",
         ctlfile="control.ss_new",
         newctlfile="control_modified.ss",
         linenums=NULL, strings=NULL, newvals=NULL,
         estimate=F, verbose=T
         )
{
################################################################################
#
# SS_changepars May 22, 2008.
# This function comes with no warranty or guarantee of accuracy
#
# Purpose: To change one or more parameter values in the Control file for SSv3
# Written: Ian Taylor, NWFSC/UW. Ian.Taylor-at-noaa.gov
# Returns: writes a new control file and returns a table of the changes made
# Notes:   requires SS_parlines
#          See users guide for documentation: http://code.google.com/p/r4ss/wiki/
# Required packages: none
#
################################################################################

  # read control file
  fullctlfile <- paste(dir,ctlfile,sep="/")
  ctl = readLines(fullctlfile)

  if(is.null(linenums) & !is.null(strings) & class(strings)=="character")
  {
    ctltable <- SS_parlines(ctlfile=fullctlfile)
    allnames <- ctltable$Label
    goodnames <- NULL
    if(!is.null(strings)){
      for(i in 1:length(strings)) goodnames <- c(goodnames,allnames[grep(strings[i],allnames)])
      goodnames <- unique(goodnames)
      print("parameters matching input vector 'strings':",quote=F)
      print(paste("parameter names in control file:"),quote=F)
      print(goodnames)
      if(length(goodnames)==0){
        print("No parameters names match input vector 'strings'.",quote=F)
        return()
      }
    }
    nvals <- length(goodnames)
    print(ctltable[ctltable$Label==goodnames[i],])
    for(i in 1:nvals) linenums[i] <- ctltable$Linenum[ctltable$Label==goodnames[i]]
  }else{
    if(is.null(linenums)) return("valid input needed for either 'linenums' or 'strings'")
  }
  ctlsubset <- ctl[linenums]
  print(paste("line numbers in control file:"),quote=F)
  print(linenums)
  # define objects to store changes
  newctlsubset <- NULL
  cmntvec <- NULL
  nvals <- length(linenums)
  oldvals <- oldphase <- newphase <- rep(NA,nvals)

  # check inputs
  if(!is.null(newvals) & length(newvals)!=nvals) return("'newvals' and either 'linenums' or 'strings' should have the same number of elements")
  if(!(length(estimate) %in% c(1,nvals))) return("'estimate' should have 1 element or same number as 'newvals'")
  if(length(estimate)==1) estimate <- rep(estimate, nvals)

  # loop over line numbers to replace parameter values
  for(i in 1:nvals)
  {
    splitline <- strsplit(ctlsubset[i], "#")[[1]]
    cmnt <- paste("#",paste(splitline[-1],collapse="#"),sep='')
    cmntvec <- c(cmntvec, cmnt)
    vecstrings <- strsplit(splitline[1]," +")[[1]]
    vec <- as.numeric(vecstrings[vecstrings!=""])
    print(vec)
    if(max(is.na(vec))==1) return(paste("There's a problem with a non-numeric value in line",linenums[i]))
    oldvals[i] <- vec[3]
    if(!is.null(newvals)) vec[3] <- newvals[i]
    oldphase[i] <- as.numeric(vec[7])
    if(estimate[i]){
      vec[7] <- abs(oldphase[i])
    }else{
      vec[7] <- -abs(oldphase[i])
    }
    newphase[i] <- vec[7]
    newline <- paste("",paste(vec, collapse=" "), cmnt)
    newctlsubset <- rbind(newctlsubset, newline)
  }
  # write new file
  newctl <- ctl
  newctl[linenums] <- newctlsubset
  writeLines(newctl, paste(dir,newctlfile,sep="/"))
  if(verbose) print(paste('wrote new file to',newctlfile),quote=F)
  # output table of changes
  if(is.null(newvals)) newvals <- NA
  print(oldvals)
  print(newvals)
  print(oldphase)
  print(newphase)
  if(verbose) return(data.frame(oldvals, newvals, oldphase, newphase, comment=cmntvec))

} # end function

