% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSplotPars.R
\name{SSplotPars}
\alias{SSplotPars}
\title{Plot distributions of priors, posteriors, and estimates.}
\usage{
SSplotPars(dir = "c:/path/", repfile = "Report.sso",
  xlab = "Parameter value", ylab = "Density", postfile = "posteriors.sso",
  showpost = TRUE, showprior = TRUE, showmle = TRUE, showinit = TRUE,
  showrecdev = TRUE, priorinit = TRUE, priorfinal = TRUE,
  showlegend = TRUE, fitrange = FALSE, xaxs = "i", xlim = NULL,
  ylim = NULL, verbose = TRUE, nrows = 3, ncols = 3, ltyvec = c(1, 1,
  3, 4), colvec = c("blue", "red", "black", "gray60", rgb(0, 0, 0, 0.5)),
  new = TRUE, pdf = FALSE, pwidth = 6.5, pheight = 5, punits = "in",
  ptsize = 10, returntable = FALSE, strings = c(), exact = FALSE,
  newheaders = NULL, burn = 0, thin = 1, ctlfile = "control.ss_new")
}
\arguments{
\item{dir}{Directory where all files are located.}

\item{repfile}{Name of report file. Default="Report.sso".}

\item{xlab}{Label on horizontal axis.}

\item{ylab}{Label on vertical axis.}

\item{postfile}{Name of MCMC posteriors file (not required).
Default="posteriors.sso".}

\item{showpost}{Show posterior distribution as bar graph? Default=TRUE.}

\item{showprior}{Show prior distribution as black line? Default=TRUE.}

\item{showmle}{Show MLE estimate and asymptotic variance estimate with blue
lines? Default=TRUE.}

\item{showinit}{Show initial value as red triangle? Default=TRUE.}

\item{showrecdev}{Include recdevs in the plot? Default=TRUE.}

\item{priorinit}{TRUE/FALSE for prior probability at initial value (not
implemented).}

\item{priorfinal}{TRUE/FALSE for prior probability at final value (not
implemented).}

\item{showlegend}{Show the legend? Default=TRUE.}

\item{fitrange}{Fit range tightly around MLE & posterior distributions,
instead of full parameter range? Default=FALSE.}

\item{xaxs}{Parameter input for x-axis. See \code{?par} for more info.
Default="i".}

\item{xlim}{Optional x-axis limits to be applied to all plots.  Otherwise,
limits are based on the model results. Default=NULL.}

\item{ylim}{Optional y-axis limits to be applied to all plots.  Otherwise,
limits are based on the model results. Default=NULL.}

\item{verbose}{Controls amount of text output (maybe). Default=TRUE.}

\item{nrows}{How many rows in multi-figure plot. Default=3.}

\item{ncols}{How many columns in multi-figure plot. Default=3.}

\item{ltyvec}{Vector of line types used for lines showing MLE and prior
distributions and the median of the posterior distribution}

\item{colvec}{Vector of colors used for lines and polygons showing MLE, 
initial value, prior, posterior, and median of the posterior.}

\item{new}{Open new window for plotting? Default=TRUE.}

\item{pdf}{Write to PDF file instead of R GUI? Default=FALSE.}

\item{pwidth}{Default width of plots printed to files in units of
\code{punits}. Default=7.}

\item{pheight}{Default height width of plots printed to files in units of
\code{punits}. Default=7.}

\item{punits}{Units for \code{pwidth} and \code{pheight}. Can be "px"
(pixels), "in" (inches), "cm" or "mm". Default="in".}

\item{ptsize}{Point size for plotted text in plots printed to files (see
help("png") in R for details). Default=12.}

\item{returntable}{Return table of parameter info? Default=FALSE.}

\item{strings}{Subset parameters included in the plot using substring from
parameter names (i.e. "SR" will get "SR_R0" and "SR_steep" if they are both
estimated quantities in this model). Default=c().}

\item{exact}{Should strings input match parameter names exactly?  Otherwise
substrings are allowed. Default=FALSE.}

\item{newheaders}{Optional vector of headers for each panel to replace the
parameter names. Default=NULL.}

\item{burn}{Additional burn-in applied to MCMC posteriors. Default=0.}

\item{thin}{Additional thinning applied to MCMC posteriors. Default=1.}

\item{ctlfile}{Specify control file to get min and max recdev values
(otherwise assumed to be -5 and 5). Default="control.ss_new".}
}
\description{
Make multi-figure plots of prior, posterior, and estimated asymptotic
parameter distributions. MCMC not required to make function work.
}
\examples{

\dontrun{
pars <- SSplotPars(dir='c:/SS/Simple/')

# strings can be partial match
pars <- SSplotPars(dir='c:/SS/Simple/',strings=c("steep"))
}

}
\author{
Ian Taylor
}
\keyword{hplot}

