% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.out.R
\name{mcmc.out}
\alias{mcmc.out}
\title{Summarize, analyze and plot key MCMC output.}
\usage{
mcmc.out(directory = "c:/mydirectory/", run = "mymodel/",
  file = "keyposteriors.csv", namefile = "postplotnames.sso",
  names = FALSE, headernames = TRUE, numparams = 1, closeall = TRUE,
  burn = 0, thin = 1, scatter = FALSE, surface = FALSE, surf1 = 1,
  surf2 = 2, stats = FALSE, plots = TRUE, header = TRUE, sep = ",",
  print = FALSE, new = T, colNames = NULL)
}
\arguments{
\item{directory}{Directory where all results are located, one level above
directory for particular run.}

\item{run}{Directory with files from a particular run.}

\item{file}{File containing posterior samples for key parameters. This could
be written by the function \code{\link{SSgetMCMC}}.}

\item{namefile}{The (optional) file name of the dimension and names of
posteriors.}

\item{names}{Read in names file (T) or use generic naming (F).}

\item{headernames}{Use the names in the header of \code{file}?}

\item{numparams}{The number of parameters to analyze.}

\item{closeall}{By default close all open devices.}

\item{burn}{Optional burn-in value to apply on top of the option in the
starter file and \code{\link{SSgetMCMC}}.}

\item{thin}{Optional thinning value to apply on top of the option in the
starter file, in the \code{-mcsave} runtime command, and in
\code{\link{SSgetMCMC}}.}

\item{scatter}{Can add a scatter-plot of all params at end, default is none.}

\item{surface}{Add a surface plot of 2-way correlations.}

\item{surf1}{The first parameter for the surface plot.}

\item{surf2}{The second parameter for the surface plot.}

\item{stats}{Print stats if desired.}

\item{plots}{Show plots or not.}

\item{header}{Data file with header?}

\item{sep}{Separator for data file passed to the \code{read.table} function.}

\item{print}{Send to screen unless asked to print.}

\item{new}{Logical whether or not to open a new plot window before plotting}

\item{colNames}{Specific names of the \code{file} to extract and work with. \code{NULL} keeps all columns}
}
\description{
Makes four panel plot showing trace plots, moving average, autocorrelations,
and densities for chosen parameters from MCMC output.
}
\examples{

  \dontrun{
      mcmc.df <- SSgetMCMC(dir="mcmcRun", writecsv=T,
                  keystrings = c("NatM", "R0", "steep", "Q_extraSD"),
                  nuisancestrings = c("Objective_function", "SPB_", "InitAge", "RecrDev"))
      mcmc.out("mcmcRun",run="",numparams=4,closeall=F)

  #Or for more control
      par(mar=c(5,3.5,0,0.5),oma=c(0,2.5,0.2,0))
      mcmc.out("mcmcRun",run="",numparams=1,closeall=F,new=F,colNames=c("NatM_p_1_Fem_GP_1"))
      mtext("M (natural mortality)",side=2,outer=T,line=1.5,cex=1.1)
  }
}
\author{
Ian Stewart, Allan Hicks (modifications)
}
\seealso{
\code{\link{mcmc.nuisance}}, \code{\link{SSgetMCMC}}
}
\keyword{hplot}

