/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r;

import com.conveyal.r5.common.GeometryUtils;
import com.conveyal.r5.profile.StreetMode;
import com.conveyal.r5.streets.Split;
import com.conveyal.r5.transit.TransportNetwork;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.concurrent.ForkJoinPool;

public class SnapFinder {
    protected final ForkJoinPool r5rThreadPool;
    protected final TransportNetwork transportNetwork;
    protected String[] fromIds;
    protected double[] fromLats;
    protected double[] fromLons;
    private StreetMode mode;
    protected int nOrigins;

    public void setMode(String mode) {
        this.mode = StreetMode.valueOf((String)mode);
    }

    public SnapFinder(ForkJoinPool threadPool, TransportNetwork transportNetwork) {
        this.r5rThreadPool = threadPool;
        this.transportNetwork = transportNetwork;
    }

    public void setOrigins(String[] fromIds, double[] fromLats, double[] fromLons) {
        this.fromIds = fromIds;
        this.fromLats = fromLats;
        this.fromLons = fromLons;
        this.nOrigins = fromIds.length;
    }

    public LinkedHashMap<String, Object> run() {
        int[] requestIndices = new int[this.nOrigins];
        for (int i = 0; i < this.nOrigins; ++i) {
            requestIndices[i] = i;
        }
        double[] snapLats = new double[this.nOrigins];
        double[] snapLons = new double[this.nOrigins];
        double[] distance = new double[this.nOrigins];
        boolean[] found = new boolean[this.nOrigins];
        Arrays.stream(requestIndices).parallel().forEach(index -> {
            Split split = this.transportNetwork.streetLayer.findSplit(this.fromLats[index], this.fromLons[index], 1600.0, this.mode);
            if (split != null) {
                snapLats[index] = (double)split.fixedLat / 1.0E7;
                snapLons[index] = (double)split.fixedLon / 1.0E7;
                distance[index] = GeometryUtils.distance((double)this.fromLats[index], (double)this.fromLons[index], (double)snapLats[index], (double)snapLons[index]);
                found[index] = true;
            } else {
                snapLats[index] = this.fromLats[index];
                snapLons[index] = this.fromLons[index];
                distance[index] = -1.0;
                found[index] = false;
            }
        });
        LinkedHashMap<String, Object> snapTable = new LinkedHashMap<String, Object>();
        snapTable.put("point_id", this.fromIds);
        snapTable.put("lat", this.fromLats);
        snapTable.put("lon", this.fromLons);
        snapTable.put("snap_lat", snapLats);
        snapTable.put("snap_lon", snapLons);
        snapTable.put("distance", distance);
        snapTable.put("found", found);
        return snapTable;
    }
}

