% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_amTimeSeries.R
\name{amTimeSeries}
\alias{amTimeSeries}
\title{Plotting times series (with or without aggregation)}
\usage{
amTimeSeries(
  data,
  col_date,
  col_series,
  main = "",
  ylab = "",
  color = c("#2E2EFE", "#31B404", "#FF4000", "#AEB404"),
  type = c("line"),
  bullet = NULL,
  bulletSize = 2,
  linetype = c(0, 5, 10, 15, 20),
  linewidth = c(1, 1, 1, 1, 1, 1),
  fillAlphas = 0,
  precision = 1,
  connect = FALSE,
  export = FALSE,
  legend = TRUE,
  legendPosition = "bottom",
  legendHidden = FALSE,
  aggregation = c("Average", "Low", "High", "Sum"),
  maxSeries = 300,
  groupToPeriods = c("ss", "mm", "hh", "DD", "MM", "YYYY"),
  checkGroupToPeriods = TRUE,
  ZoomButton = data.frame(Unit = "MAX", multiple = 1, label = "All"),
  ZoomButtonPosition = "bottom",
  periodFieldsSelection = FALSE,
  scrollbar = TRUE,
  scrollbarPosition = "bottom",
  scrollbarHeight = 40,
  scrollbarGraph = NULL,
  cursor = TRUE,
  cursorValueBalloonsEnabled = TRUE,
  creditsPosition = "top-right",
  group = NULL,
  is_ts_module = FALSE,
  dataDateFormat = "YYYY-MM-DD JJ:NN:SS",
  categoryBalloonDateFormats = list(list(period = "YYYY", format = "YYYY"), list(period
    = "MM", format = "YYYY-MM"), list(period = "WW", format = "YYYY-MM-DD"), list(period =
    "DD", format = "YYYY-MM-DD"), list(period = "hh", format = "YYYY-MM-DD JJ:NN"),
    list(period = "mm", format = "YYYY-MM-DD JJ:NN"), list(period = "ss", format =
    "YYYY-MM-DD JJ:NN:SS"), list(period = "fff", format = "YYYY-MM-DD JJ:NN:SS")),
  dateFormats = list(list(period = "YYYY", format = "YYYY"), list(period = "MM", format
    = "MMM"), list(period = "WW", format = "MMM DD"), list(period = "DD", format =
    "MMM DD"), list(period = "hh", format = "JJ:NN"), list(period = "mm", format =
    "JJ:NN"), list(period = "ss", format = "JJ:NN:SS"), list(period = "fff", format =
    "JJ:NN:SS")),
  ...
)
}
\arguments{
\item{data}{\code{data.frame}, data of graph.}

\item{col_date}{\code{character} name of date column}

\item{col_series}{\code{character} names of series columns}

\item{main}{\code{character}, title.}

\item{ylab}{\code{character}, value axis label.}

\item{color}{\code{character}, color of series (in hexadecimal).}

\item{type}{\code{character}, Type of graph. Possible values are : "line" (default),
"column", "step", "smoothedLine"}

\item{bullet}{\code{character}, point shape. Possible values are : "diamond", "square", 
"bubble",  "yError", "xError", "round", "triangleLeft", "triangleRight", "triangleUp", "triangleDown"}

\item{bulletSize}{: \code{numeric}, size of bullet.}

\item{linetype}{: \code{numeric}, line type, 0 : solid, number : dashed length}

\item{linewidth}{: \code{numeric}, line width.}

\item{fillAlphas}{: \code{numeric}, fill. Between 0 (no fill) to 1.}

\item{precision}{\code{numeric}, default set to  1.}

\item{connect}{\code{logical}, default set to  FALSE. Specifies whether to connect data points if data is missing.}

\item{export}{\code{logical}, default set to  FALSE. TRUE to display export feature.}

\item{legend}{\code{logical}, enabled or not legend ? Defaut to TRUE.}

\item{legendPosition}{\code{character}, legend position. Possible values are :
"left", "right", "bottom", "top"}

\item{legendHidden}{\code{logical} hide some series on rendering ? Defaut to FALSE}

\item{aggregation}{\code{character}, aggregation type. Possible values are : 
"Low", "High", "Average" and "Sum"}

\item{maxSeries}{\code{numeric} Maximum series shown at a time.
In case there are more data points in the selection than maxSeries,
the chart will group data to longer periods,
for example - you have 250 days in the selection,
and maxSeries is 150 - the chart will group data to weeks.}

\item{groupToPeriods}{\code{character}, Periods to which data will
be grouped in case there are more data items in the selected
period than specified in maxSeries property. Possible value are :
'ss', 'mm', 'hh', 'DD', 'MM', 'YYYY'. It's also possible to add multiple like "30mm". Or NULL to disable.}

\item{checkGroupToPeriods}{\code{logical}. Check groupToPeriods ? Default to TRUE then check validity
between data and groupToPeriods, else use directly groupToPeriods}

\item{ZoomButton}{\code{data.frame}, 3 or 4 columns : 
\itemize{
 \item{"Unit"}{ : Character. Times unit. 'ss', 'mm', 'hh', 'DD', 'MM', 'YYYY'}
 \item{"multiple"}{ : Numeric. multiple*unit }
 \item{"label"}{ : Character. button's label }
 \item{"selected"}{ : Boolean. Optional. To set initial selection. (One TRUE, others FALSE)}
}}

\item{ZoomButtonPosition}{\code{character}, zoom button position. Possible values are :
"left", "right", "bottom", "top"}

\item{periodFieldsSelection}{\code{boolean}, using zoom button, add also two fields to select period ?}

\item{scrollbar}{\code{boolean}, enabled or not scrollbar ? Defaut to TRUE.}

\item{scrollbarPosition}{\code{character}, scrollbar position. Possible values are :
"left", "right", "bottom", "top"}

\item{scrollbarHeight}{\code{numeric}, height of scroll bar. Default : 40.}

\item{scrollbarGraph}{\code{character}, name of serie (column) to print in scrollbar. Defaut to NULL.}

\item{cursor}{\code{boolean}, enabled or not cursor ? Defaut to TRUE.}

\item{cursorValueBalloonsEnabled}{\code{boolean}, if cursor, enabled or not balloons on cursor ? Defaut to TRUE.}

\item{creditsPosition}{\code{character}, credits position. Possible values are :
"top-right", "top-left", "bottom-right", "bottom-left"}

\item{group}{\code{character}, like in \code{dygraphs}, for synchronization in \code{shiny} or \code{rmarkdown}.}

\item{is_ts_module}{\code{boolean}. Don't use. For \link{rAmChartsTimeSeriesUI}}

\item{dataDateFormat}{\code{character} Data date format. Default to 'YYYY-MM-DD JJ:NN:ss'. See details.}

\item{categoryBalloonDateFormats}{\code{list} Date format objects for chart cursor. See details.}

\item{dateFormats}{\code{list} Date format objects for x-axis. See details.}

\item{...}{other first level attributes}
}
\description{
amTimeSeries computes a stock chart.
}
\details{
For dateFormats & categoryBalloonDateFormats

Available periods are: fff - millisecond, ss - second, mm - minute, hh - hour, DD - date, WW - week, MM - month, YYYY - year

Available formats : 

Year. The number of Y letters represents digits in the resulting number. I.e.:
YY = 05 (always two digits), YYYY = 2005

Month of the year. The output depends on the number of M's:
M = 8 (one or two digits), MM = 08 (always two digits),
MMM = Aug (3-letter month abbreviation), 
MMMM = August (full month name)

Week of the year W

Day of the month: D = 7 (one or two digits), DD = 07 (always two digits)

Day of week: E = 2 (single digit day of week), EE = 02 (two-digit day of week), 
EEE = Tue (3-letter abbreviation of the literal representation of the day of week), 
EEEE = Tuesday (full day of week name)

Hour: 0-23: J = 3 (one or two digits), JJ = 03 (always two digits)
	
Hour: 1-24: H = 3 (one or two digits), HH = 03 (always two digits)
K 	Hour in am/pm: 0-11
L 	Hour in am/pm: 1-12 *
	
Minute in hour: N = 8 (one or two digits), NN = 08 (always two digits)
	
Second in minute: S = 5 (one or two digits), SS = 05 (always two digits)
	
Milliseconds: QQ = 51, QQQ = 051
	
Other characters 	Other characters will be displayed as they are without changing 
them. I.e.:YYYY-MM-DD = 2013-03-01
}
\examples{
data("data_stock_2")
amTimeSeries(data_stock_2, "date", c("ts1", "ts2"))

\dontrun{
# upper /lower
data <- data_stock_2[1:50, ]
data$ts1low <- data$ts1-100
data$ts1up <- data$ts1+100

amTimeSeries(data, "date", list(c("ts1low", "ts1", "ts1up"), "ts2"))
amTimeSeries(data, "date", list(c("ts1low", "ts1", "ts1up"), "ts2"), 
              color = c("red", "blue"), bullet = c("round", "square"))

# column / step
amTimeSeries(data_stock_2, "date", c("ts1", "ts2"), 
              type = c("column", "step"), fillAlphas = c(1, 0),
              linewidth = c(0, 1))
 
# some parameters
amTimeSeries(data_stock_2, "date", c("ts1", "ts2"), bullet = "round")
amTimeSeries(data_stock_2, "date", c("ts1", "ts2"), bullet = "round",
              groupToPeriods = c('hh', 'DD', '10DD'))

amTimeSeries(data_stock_2, "date", c("ts1", "ts2"), bullet = "round",
              groupToPeriods = c('12hh', 'DD', '10DD'),
              maxSeries = 50)
              
amTimeSeries(data_stock_2, "date", c("ts1", "ts2"), bullet = "round",
             groupToPeriods = c('hh', 'DD', '10DD'),
             linewidth = c(3, 1))
             
amTimeSeries(data_stock_2, "date", c("ts1", "ts2"), aggregation = "Sum")


amTimeSeries(data_stock_2, "date", c("ts1", "ts2"), bullet = "round",
              groupToPeriods = c('12hh', 'DD', '10DD'),
              maxSeries = 50, precision = 5)

amTimeSeries(data_stock_2, "date", c("ts1", "ts2"), bullet =  c("diamond", "square"),
             linetype = 0, bulletSize = c(5, 10),
             groupToPeriods = c('12hh', 'DD', '10DD'),
             maxSeries = 50, aggregation = "Sum")


ZoomButton <- data.frame(Unit = c("DD", "DD", "MAX"), multiple = c(1, 2 ,1),
                        label = c("Day","2 days", "MAX"))
amTimeSeries(data_stock_2, "date", c("ts1", "ts2"), bullet = "round",
             ZoomButton = ZoomButton, main = "My title", ylab = "Interest")
             
amTimeSeries(data_stock_2, "date", c("ts1", "ts2"), bullet = "round",
             ZoomButton = ZoomButton, main = "My title", ylab = "Interest",
             export = TRUE, ZoomButtonPosition = "right",
             legendPosition = "bottom", scrollbarPosition = "top")
         
amTimeSeries(data_stock_2, "date", c("ts1", "ts2"), bullet = "round",
             ZoomButton = ZoomButton, main = "My title",
             ylab = "Interest", export = TRUE,
             creditsPosition = "bottom-left")
             
# date formats

amTimeSeries(data_stock_2, "date", c("ts1", "ts2"), 
  type = "column", fillAlphas = 1, 
  linewidth = 0, legendHidden = T, 
  categoryBalloonDateFormats = list(list(period = 'YYYY', format = 'YYYY'),
                                    list(period='MM', format = 'MM'), 
                                    list(period = 'WW', format = 'MM-DD'),
                                    list(period='DD', format = 'MM-DD'), 
                                    list(period = 'hh', format = 'MM-DD JJ:NN'),
                                    list(period='mm', format = 'MM-DD JJ:NN'), 
                                    list(period = 'ss', format = 'MM-DD JJ:NN:SS'),
                                    list(period='fff', format = 'MM-DD JJ:NN:SS')),
  dateFormats = list(list(period = 'YYYY', format = 'YYYY'),
                     list(period='MM', format = 'MMMM'), 
                     list(period = 'WW', format = 'MMMM-DD'),
                     list(period='DD', format = 'MMMM-DD'), 
                     list(period = 'hh', format = 'MM-DD JJ:NN'),
                     list(period='mm', format = 'MM-DD JJ:NN'), 
                     list(period = 'ss', format = 'MM-DD JJ:NN:SS'),
                     list(period='fff', format = 'MM-DD JJ:NN:SS')))              
             
}

}
\references{
See online documentation \url{https://datastorm-open.github.io/introduction_ramcharts/}
and \link{amChartsAPI}
}
\seealso{
\link{rAmChartsTimeSeriesUI} for shiny module, \link{amOptions}, \link{amBarplot}, \link{amBoxplot}, \link{amHist}, \link{amPie},
\link{amPlot}, \link{amTimeSeries}, \link{amStockMultiSet}, \link{amBullet}, \link{amRadar}, 
\link{amWind}, \link{amFunnel}, \link{amAngularGauge}, \link{amSolidGauge}, \link{amMekko},
\link{amCandlestick}, \link{amFloatingBar}, \link{amOHLC}, \link{amWaterfall}
}
