% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_StockPanel.R,
%   R/class_StockPanel_setters.R
\name{initialize,StockPanel-method}
\alias{initialize,StockPanel-method}
\alias{stockPanel}
\alias{panel}
\alias{setDrawOnAxis}
\alias{setDrawOnAxis,StockPanel,ValueAxisOrCharacterOrMissing-method}
\alias{setStockGraphs}
\alias{setStockGraphs,StockPanel,list-method}
\alias{addStockGraph}
\alias{addStockGraph,StockPanel,AmGraphOrMissing-method}
\alias{setStockLegend}
\alias{setStockLegend,StockPanel,AmLegendOrMissing-method}
\title{Initialize a StockPanel}
\usage{
\S4method{initialize}{StockPanel}(
  .Object,
  allLabels,
  axes,
  balloon,
  categoryAxis,
  categoryField,
  chartCursor,
  chartScrollbar,
  creditsPosition,
  dataProvider,
  graphs,
  graph,
  guides,
  legend,
  theme,
  title,
  titles,
  trendLines,
  type,
  valueAxes,
  valueScrollbar,
  drawOnAxis,
  stockGraphs,
  stockLegend,
  ...
)

stockPanel(...)

panel(...)

setDrawOnAxis(.Object, valueAxis = NULL, ...)

\S4method{setDrawOnAxis}{StockPanel,ValueAxisOrCharacterOrMissing}(.Object, valueAxis = NULL, ...)

setStockGraphs(.Object, stockGraphs)

\S4method{setStockGraphs}{StockPanel,list}(.Object, stockGraphs)

addStockGraph(.Object, stockGraph = NULL, ...)

\S4method{addStockGraph}{StockPanel,AmGraphOrMissing}(.Object, stockGraph = NULL, ...)

setStockLegend(.Object, stockLegend = NULL, ...)

\S4method{setStockLegend}{StockPanel,AmLegendOrMissing}(.Object, stockLegend = NULL, ...)
}
\arguments{
\item{.Object}{\linkS4class{StockPanel}.}

\item{allLabels}{\code{list} of \linkS4class{Label}.
Example of a label object, with all possible properties:
label(x = 20, y = 20, text = "this is a label", align = "left", size = 12, color = "#CC0000",
      alpha = 1, rotation = 0, bold = TRUE, url = "http=//www.amcharts.com").
Run \code{api("Label")} for more informations.}

\item{axes}{\code{list} of \linkS4class{GaugeAxis} properties.
Only valid for gauge charts.
Run \code{api("GaugeAxis")} for more informations.}

\item{balloon}{\linkS4class{AmBalloon}.
Creates the balloons (tooltips) of the chart.
It follows the mouse cursor when you roll-over the data items.
The framework automatically generates the instances you just have to adjust
the appearance to your needs.
Run \code{api("AmBalloon")} for more informations.}

\item{categoryAxis}{\linkS4class{CategoryAxis}.
Read-only. Chart creates category axis itself.
If you want to change some properties,
you should get this axis from the chart and set properties to this object.
Run \code{api("CategoryAxis")} for more informations.}

\item{categoryField}{\code{character}, 
category field name indicates the name of the field in your dataProvider object
which will be used for category axis values.}

\item{chartCursor}{\linkS4class{ChartCursor}.
Chart's cursor.
Run \code{api("ChartCursor")} for more informations.}

\item{chartScrollbar}{\linkS4class{ChartScrollbar}.
Chart's scrollbar.
Run \code{api("ChartScrollbar")} for more informations.}

\item{creditsPosition}{\code{character}, 
specifies position of the amCharts' website link.
Allowed values are: "top-left", "top-right", "bottom-left" and "bottom-right".}

\item{dataProvider}{\code{data.frame}, containing the data.}

\item{graphs}{\code{list} of \linkS4class{AmGraph}.
Creates the visualization of the data in following types: line, column, step line,
smoothed line, olhc and candlestick.
Run \code{api("AmGraph")} for more informations.}

\item{graph}{\linkS4class{AmGraph}.
Only valid for Gantt charts.
Gant chart actually creates multiple graphs (separate for each segment).
Properties of this graph are passed to each of the created graphs
- this allows you to control the look of segments.
Run \code{api("AmGraph")} for more informations.}

\item{guides}{\code{list} of \linkS4class{Guide}.
Instead of adding guides to the axes, you can push all of them to this array.
In case guide has category or date defined, it will automatically be assigned to the category axis,
otherwise to the first value axis, unless you specify a different valueAxes for the guide.
Run \code{api("Guide")} for more informations.}

\item{legend}{\linkS4class{AmLegend}.
Legend of a chart.
Run \code{api("AmLegend")} for more informations.}

\item{theme}{\code{character}, 
theme of a chart. Config files of themes can be found in amcharts/themes/ folder.
See \url{http://www.amcharts.com/tutorials/working-with-themes/}.}

\item{title}{A title of a panel. Note, StockLegend should be added in order title to be displayed.}

\item{titles}{\code{list} of \linkS4class{Title}.
Run \code{api("Title")} for more informations.}

\item{trendLines}{\code{list} of \linkS4class{TrendLine} objects added to the chart.
You can add trend lines to a chart using this list or access already existing trend lines.
Run \code{api("TrendLine")} for more informations.}

\item{type}{\code{character}, 
possible types are: "serial", "pie", "radar", "xy", "radar", "funnel", "gauge", "stock".
See details about using argument type.
(type map is in development).}

\item{valueAxes}{\code{list} of \linkS4class{ValueAxis}.
Chart creates one value axis automatically,
so if you need only one value axis, you don't need to create it.
Run \code{api("ValueAxis")} for more informations.}

\item{valueScrollbar}{\linkS4class{ChartScrollbar}.
Value scrollbar, enables scrolling value axes.}

\item{drawOnAxis}{\linkS4class{ValueAxis}.
Specifies on which value axis user can draw trend lines.
Set drawingIconsEnabled to true if you want drawing icons to be visible.
First value axis will be used if not set here.
You can use a reference to the value axis object or id of value axis.}

\item{stockGraphs}{\code{list} of \linkS4class{AmGraph}.
Each element must be have been created with stockGraph(*)}

\item{stockLegend}{\code{list} of \linkS4class{AmLegend}.
Each element must be have been created with stockLegend(*)}

\item{...}{other properties of StockPanel.}

\item{valueAxis}{A \linkS4class{ValueAxis} for the property 'drawnOnAxis'.}

\item{stockGraph}{\linkS4class{AmGraph}, created with stockGraph(...).
Argument for method \code{addStockGraph}.}
}
\value{
(updated) \linkS4class{StockPanel} with given properties.
}
\description{
Use the constructor to create the object
or update an existing one with the setters.
}
\examples{
new("StockPanel", title = "Volume")

stockPanel(stockLegend = amLegend(useGraphSettings = TRUE))
panel(creditsPosition = "top-right")
panel(title = "top-right")
valueAxis_obj <- valueAxis(id = "valueAxis1")
setDrawOnAxis(.Object = stockPanel(), valueAxis = valueAxis_obj)
setDrawOnAxis(.Object = stockPanel(), valueAxis = "valueAxis1")
# ---
stockGraphs <- list(stockGraph(comparable = TRUE), stockGraph(comparable = FALSE)) 
setStockGraphs(.Object =  stockPanel(), stockGraphs = stockGraphs)
stockPanel(stockGraphs = stockGraphs)
# ---
stock_panel <- addStockGraph(.Object = stockPanel(), comparable = FALSE); print(stock_panel)
# or...
stock_panel <- addStockGraph(.Object = stockPanel(), stockGraph = stockGraph(comparable = FALSE))
# ---
setStockLegend(.Object = stockPanel(), valueTextRegular = "[[value]]")
# equivalent to:
stockLegend_obj <- stockLegend(valueTextRegular = "[[value]]")
setStockLegend(.Object = stockPanel(), stockLegend = stockLegend_obj)
# ---
}
