% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_modules_export.R
\name{rAmCharts-shinymodules}
\alias{rAmCharts-shinymodules}
\alias{rAmChartsExportServerUI}
\alias{rAmChartsExportServer}
\title{Shiny module to export rAmCharts graphics on server-side}
\usage{
rAmChartsExportServerUI(id)

rAmChartsExportServer(input, output, session, list_am_graph,
  path = shiny::reactive(tempdir()), mode = "single", progress = T,
  message = "Calculation in progress", detail = "This may take a while...")
}
\arguments{
\item{id}{character, used to specify namesapce, see \code{shiny::\link[shiny]{NS}}}

\item{input}{standard, \code{shiny} input}

\item{output}{standard, \code{shiny} output}

\item{session}{standard, \code{shiny} session}

\item{list_am_graph}{named list, reactive expression with all amCharts to export
\itemize{
 \item{"graph"}{rAmCharts object to export}
 \item{"name"}{character, name of file, with ".jpg" extension}
 \item{"width"}{Optionnal, character. Linked to \link{amChartsOutput}}
 \item{"height"}{Optionnal, character. Linked to \link{amChartsOutput}}
 \item{"type"}{Optionnal, character. Linked to \link{amChartsOutput}}
}}

\item{path}{character, directory. tempdir() by Defaut}

\item{mode}{character, 'single' : graphics are rendered and saved one by one. 'multiple' all at same time}

\item{progress}{boolean, set a progress bar or not ?}

\item{message}{character, if progress, message. Defaut to "Calculation in progress"}

\item{detail}{character, if progress, detail. Defaut to "This may take a while...'}
}
\value{
a reactive expression
}
\description{
This function need the \code{base64enc} package to save image.
}
\examples{

\dontrun{

# ui
rAmChartExportServerUI("export_server_graphs")

# server

mult_amgraph <- reactive({
 if(input$goSave > 0){
   isolate({
     list(
       list(graph = amPie(data = data_pie), name = "pie.jpg", height = "200px", width = "300px"),
       list(graph = amBarplot(x = "country", y = "visits", data = data_bar, main = "example") \%>\%
         setExport(), name = "bar.jpg", height = "600px")
     )
   })
 } else {
   NULL
 }
})


callModule(rAmChartExportServer, "export_server_graphs", mult_amgraph, 
          reactive("/home/benoit/amchart_export"))

}
}
