% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amStackedBarChart.R
\name{amStackedBarChart}
\alias{amStackedBarChart}
\title{HTML widget displaying a stacked bar chart}
\usage{
amStackedBarChart(
  data,
  data2 = NULL,
  category,
  stacks,
  seriesNames = NULL,
  yLimits = NULL,
  expandY = 5,
  valueFormatter = "#.",
  chartTitle = NULL,
  theme = NULL,
  tooltip = NULL,
  threeD = FALSE,
  backgroundColor = NULL,
  cellWidth = NULL,
  columnWidth = NULL,
  xAxis = NULL,
  yAxis = NULL,
  scrollbarX = FALSE,
  scrollbarY = FALSE,
  legend = NULL,
  caption = NULL,
  image = NULL,
  button = NULL,
  cursor = FALSE,
  width = NULL,
  height = NULL,
  export = FALSE,
  chartId = NULL,
  elementId = NULL
)
}
\arguments{
\item{data}{a dataframe}

\item{data2}{\code{NULL} or a dataframe used to update the data with the
button; its column names must include the column names of \code{data}
given in \code{series}, it must have the same number of rows as
\code{data} and its rows must be in the same order as those of \code{data}}

\item{category}{name of the column of \code{data} to be used on the
category axis}

\item{stacks}{a list of stacks; a stack is a character vector of the form
\code{c("series3", "series1", "series2")}, and the first element of a
stack corresponds to the bottom of the column}

\item{seriesNames}{names of the series variables (the variables which appear
in the stacks), to appear in the legend; \code{NULL} to use the variables
given in \code{stacks} as names, otherwise a named list of the
form \code{list(series1 = "SeriesName1", series2 = "SeriesName2", ...)}
where \code{series1}, \code{series2}, ... are the column names given in
\code{stacks} and \code{"SeriesName1"}, \code{"SeriesName2"}, ... are the
desired names to appear in the legend; these names can also appear in
the tooltips: they are substituted to the string \code{{name}} in
the formatting string passed on to the tooltip}

\item{yLimits}{range of the y-axis, a vector of two values specifying
the lower and the upper limits of the y-axis; \code{NULL} for default
values}

\item{expandY}{if \code{yLimits = NULL}, a percentage of the range of the
y-axis used to expand this range}

\item{valueFormatter}{a
\href{https://www.amcharts.com/docs/v4/concepts/formatters/formatting-numbers/}{number formatting string};
it is used to format the values displayed in the cursor tooltips if
\code{cursor = TRUE}, the labels of the y-axis unless you specify
your own formatter in the \code{labels} field of the list passed on to
the \code{yAxis} option, and the values displayed in the tooltips unless
you specify your own tooltip text}

\item{chartTitle}{chart title, it can be \code{NULL} or \code{FALSE} for no
title, a character string,
a list of settings created with \code{\link{amText}}, or a list with two
fields: \code{text}, a list of settings created with \code{\link{amText}},
and \code{align}, can be \code{"left"}, \code{"right"} or \code{"center"}}

\item{theme}{theme, \code{NULL} or one of \code{"dataviz"},
\code{"material"}, \code{"kelly"}, \code{"dark"}, \code{"moonrisekingdom"},
\code{"frozen"}, \code{"spiritedaway"}, \code{"patterns"},
\code{"microchart"}}

\item{tooltip}{settings of the tooltips; \code{NULL} for default,
\code{FALSE} for no tooltip, otherwise a named list of the form
\code{list(series1 = settings1, series2 = settings2, ...)} where
\code{settings1}, \code{settings2}, ... are lists created with
\code{\link{amTooltip}}; this can also be a
single list of settings that will be applied to each series,
or a just a string for the text to display in the tooltip}

\item{threeD}{logical, whether to render the columns in 3D}

\item{backgroundColor}{a color for the chart background; a color can be
given by the name of a R color, the name of a CSS color, e.g.
\code{"rebeccapurple"} or \code{"fuchsia"}, an HEX code like
\code{"#ff009a"}, a RGB code like \code{"rgb(255,100,39)"}, or a HSL code
like \code{"hsl(360,11,255)"}}

\item{cellWidth}{cell width in percent; for a simple bar chart, this is the
width of the columns; for a grouped bar chart, this is the width of the
clusters of columns; \code{NULL} for the default value}

\item{columnWidth}{column width, a percentage of the cell width; set to 100
for a simple bar chart and use \code{cellWidth} to control the width of the
columns; for a grouped bar chart, this controls the spacing between the
columns within a cluster of columns; \code{NULL} for the default value}

\item{xAxis}{settings of the category axis given as a list, or just a string
for the axis title; the list of settings has three possible fields:
a field \code{title}, a list of settings for the axis title created
with \code{\link{amText}},
a field \code{labels}, a list of settings for the axis labels created
with \code{\link{amAxisLabels}},
and a field \code{adjust}, a number defining the vertical adjustment of
the axis (in pixels)}

\item{yAxis}{settings of the value axis given as a list, or just a string
for the axis title; the list of settings has five possible fields:
a field \code{title}, a list of settings for the axis title created
with \code{\link{amText}},
a field \code{labels}, a list of settings for the axis labels created
with \code{\link{amAxisLabels}},
a field \code{adjust}, a number defining the horizontal adjustment of
the axis (in pixels), a field \code{gridLines}, a list of settings for
the grid lines created with \code{\link{amLine}} and a field
\code{breaks} to control the axis breaks, an R object created with
\code{\link{amAxisBreaks}}}

\item{scrollbarX}{logical, whether to add a scrollbar for the category axis}

\item{scrollbarY}{logical, whether to add a scrollbar for the value axis}

\item{legend}{either a logical value, whether to display the legend, or
a list of settings for the legend created with \code{\link{amLegend}}}

\item{caption}{\code{NULL} or \code{FALSE} for no caption, a formatted
text created with \code{\link{amText}}, or a list with two fields:
\code{text}, a list created with \code{\link{amText}}, and \code{align},
can be \code{"left"}, \code{"right"} or \code{"center"}}

\item{image}{option to include an image at a corner of the chart;
\code{NULL} or \code{FALSE} for no image, otherwise a named list with four
possible fields: the field \code{image} (required) is a list created with
\code{\link{amImage}},
the field \code{position} can be \code{"topleft"}, \code{"topright"},
\code{"bottomleft"} or \code{"bottomright"}, the field \code{hjust}
defines the horizontal adjustment, and the field \code{vjust} defines
the vertical adjustment}

\item{button}{\code{NULL} for the default, \code{FALSE} for no button,
or a list of settings created with \code{\link{amButton}}; this button is
used to replace the current data with \code{data2}}

\item{cursor}{option to add a cursor on the chart; \code{FALSE} for no
cursor, \code{TRUE} for a cursor with default settings for the tooltips,
or a list of settings created with \code{\link{amTooltip}} to
set the style of the tooltips, or a list with three possible fields:
a field \code{tooltip}, a list of tooltip settings created with
\code{\link{amTooltip}}, a field
\code{extraTooltipPrecision}, an integer, the number of additional
decimals to display in the tooltips, and a field \code{modifier},
which defines a modifier for the
values displayed in the tooltips; a modifier is some JavaScript code
given as a string, which performs a modification of a string named
\code{text}, e.g. \code{modifier = "text = '>>>' + text;"}}

\item{width}{the width of the chart, e.g. \code{"600px"} or \code{"80\%"};
ignored if the chart is displayed in Shiny, in which case the width is
given in \code{\link{amChart4Output}}}

\item{height}{the height of the chart, e.g. \code{"400px"};
ignored if the chart is displayed in Shiny, in which case the height is
given in \code{\link{amChart4Output}}}

\item{export}{logical, whether to enable the export menu}

\item{chartId}{a HTML id for the chart}

\item{elementId}{a HTML id for the container of the chart; ignored if the
chart is displayed in Shiny, in which case the id is given by the Shiny id}
}
\description{
Create a HTML widget displaying a stacked bar chart.
}
\examples{
library(rAmCharts4)

dat <- data.frame(
  year     = c("2004", "2005", "2006"),
  europe   = c(10, 15, 20),
  asia     = c( 9, 10, 13),
  africa   = c( 5,  6,  8),
  meast    = c( 7,  8, 12),
  namerica = c(12, 15, 19),
  samerica = c(10, 16, 14)
)

dat2 <- data.frame(
  year     = c("2004", "2005", "2006"),
  europe   = c( 7, 12, 16),
  asia     = c( 8, 13, 10),
  africa   = c( 7,  7, 10),
  meast    = c( 8,  6, 14),
  namerica = c(10, 17, 17),
  samerica = c(12, 18, 17)
)

stacks <- list(
  c("europe", "namerica"),
  c("asia", "africa", "meast", "samerica")
)

seriesNames <- list(
  europe = "Europe",
  namerica = "North America",
  asia = "Asia",
  africa = "Africa",
  meast = "Middle East",
  samerica = "South America"
)

amStackedBarChart(
  dat,
  data2 = dat2,
  category = "year",
  stacks = stacks,
  seriesNames = seriesNames,
  yLimits = c(0, 60),
  chartTitle = amText(
    "Stacked bar chart",
    fontFamily = "Trebuchet MS",
    fontSize = 30,
    fontWeight = "bold"
  ),
  xAxis = "Year",
  yAxis = "A quantity...",
  theme = "kelly",
  button = amButton("Update", position = 1),
  height = 450
)
}
