% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBark.R
\name{getBark}
\alias{getBark}
\alias{getBark.data.frame}
\alias{getBark.list}
\alias{getBark.datBDAT}
\title{Get double bark thickness of tree at given height Hx}
\usage{
getBark(tree, ...)

\method{getBark}{data.frame}(tree, Hx = NULL, mapping = NULL, ...)

\method{getBark}{list}(tree, Hx = NULL, mapping = NULL, ...)

\method{getBark}{datBDAT}(tree, Hx = NULL, mapping = NULL, ...)
}
\arguments{
\item{tree}{either a data.frame or a list containing the variables needed to
decribe a tree, i.e. spp, D1, H, and optionally H1, D2, H2. Additionally,
parameter \code{Hx} might be directly given via \code{tree}. See
\code{\link{buildTree}} for more details and parameter \code{mapping} for
 mapping of variable names.}

\item{...}{passing arguments to methods.}

\item{Hx}{height in tree for which double bark thickness is required}

\item{mapping}{mapping of variable names in case a data.frame is given into
parameter \code{tree} between colnames(\code{tree}) and required parameter
names. See details.}
}
\value{
vector of double bark thickness given height \code{Hx} inside stem taper
}
\description{
this function calculates double bark thickness in given height
for a given tree
}
\details{
This function returns double bark thickness in given height \code{Hx} in stem
taper (hence, it depends on the diameter in given height). This can be added
to an diameter under bark to get the diameter over bark.
Parameter \code{tree} is able to take either a data.frame with correct
variables names or arbitrary names if \code{mapping} is provided to map the
data.frame names to the required names by \code{c("df-colname" = "var-name")}
or to take a named list.
}
\section{Methods (by class)}{
\itemize{
\item \code{data.frame}: transforming \code{data.frame} before calling
\code{getBark} using \code{buildTree}

\item \code{list}: transforming \code{list} before calling
\code{getBark} using \code{buildTree}

\item \code{datBDAT}: class method for class \code{datBDAT}
}}

\examples{
tree <- data.frame(spp = c(1, 1), D1 = c(30, 25), H = c(25, 25), Hx = c(1.3, 22.248))
getBark(tree)
tree <- data.frame(BDATCode = c(1, 1), dbh = c(30, 25), h = c(25, 25), Hx = c(1.3, 22.248))
getBark(tree, mapping = c("BDATCode" = "spp", "dbh" = "D1", "h" = "H"))
tree <- data.frame(BDATCode = c(1, 1), dbh = c(30, 25), h = c(25, 25))
Hx <- list(Hx = c(1.3, 22.248))
getBark(tree = tree, Hx = Hx, mapping = c("BDATCode" = "spp", "dbh" = "D1", "h" = "H"))
}
