% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_transformations.R
\name{identify_twins}
\alias{identify_twins}
\title{Construct twins based on the recurrence structure}
\usage{
identify_twins(block, phase_lock = TRUE, T_period = 24,
  quantile_vec = c(0.125, 0.12, 0.11, 0.1, 0.09, 0.08, 0.07, 0.06, 0.05, 0.15,
  0.16, 0.17, 0.18, 0.19, 0.2, 0.04), min_num_twins = 10)
}
\arguments{
\item{block}{the multivariate time series block. Each row is a data point, 
and each column is a coordinate. We expect this to be either a lagged 
block from a single time series or multiple time series.}

\item{phase_lock}{whether twins have to occur at the same phase}

\item{T_period}{the period of seasonality for seasonal surrogates 
(ignored for other methods)}

\item{quantile_vec}{the quantiles used to filter candidate twins.}

\item{min_num_twins}{how many twins are necessary to stop adjusting the 
threshold for twins}
}
\value{
A list of the twins. The list has length equal to the time 
  series, and each element is a vector of the candidate twins.
}
\description{
Identify similar points in the `original_e` data structure. 
  Use quantiles to identify close enough points. Then
}
\details{
The algorithm is as follows:
  (1) create recurrence matrix: values are 1 if their distance (using the 
     "maximum" measure) is lower than a specific quantile threshold
  (2) create twins if the columns of the recurrence matrix are identical 
      (and if the points are in the same phase, if `phase_lock = TRUE`)
  (3) check if the number of twins is satisfactor. If not, repeat and use 
      the next value of the quantile threshold
}
