% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topNwords.R, R/jst_reversed.R, R/jst.R
\docType{methods}
\name{topNwords}
\alias{topNwords}
\alias{topNwords,JST_reversed.result,numeric,numeric,numeric-method}
\alias{topNwords,JST_reversed.result,numeric,ANY,ANY-method}
\alias{topNwords,JST_reversed.result,numeric,-method}
\alias{topNwords,JST.result,numeric,numeric,numeric-method}
\alias{topNwords,JST.result,numeric,ANY,ANY-method}
\alias{topNwords,JST.result,numeric,-method}
\title{Show top N words for topics/sentiments}
\usage{
topNwords(x, N, topic = NULL, sentiment = NULL)

\S4method{topNwords}{JST_reversed.result,numeric,numeric,numeric}(x, N, topic = NULL, sentiment = NULL)

\S4method{topNwords}{JST_reversed.result,numeric,ANY,ANY}(x, N)

\S4method{topNwords}{JST.result,numeric,numeric,numeric}(x, N, topic = NULL, sentiment = NULL)

\S4method{topNwords}{JST.result,numeric,ANY,ANY}(x, N)
}
\arguments{
\item{x}{A results object from any of the models in the package}

\item{N}{Integer. The number of words to return.}

\item{topic}{(optional) Integer. The topic to return words from.}

\item{sentiment}{(optional) Integer. The sentiment to return words from.}
}
\value{
If topic and sentiment are specified: A character vector containing
 the top N words for the requested topic-sentiment combination. Otherwise a
 data.frame containing the top N words for every topic-sentiment combination.
}
\description{
This method returns a vector containing the N words with the highest
estimated parameter values for any of the models estimated in this package.
If topic (and sentiment for the appropriate models) are not specified, the
top N words of every topic will be returned.
}
\examples{
model <- jst(quanteda::dfm(quanteda::data_corpus_inaugural), paradigm())
topNwords(model, N = 30, topic = 2, sentiment = 1)
}
