% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consent.R
\name{rje_consent}
\alias{rje_consent}
\title{Obtain User Consent for rJavaEnv}
\usage{
rje_consent(provided = FALSE)
}
\arguments{
\item{provided}{Logical indicating if consent is already provided.
To provide consent in non-interactive \R sessions
use \code{rJavaEnv::rje_consent(provided = TRUE)}. Default is \code{FALSE}.}
}
\value{
\code{TRUE} if consent is given, otherwise an error is raised.
}
\description{
Get user consent for rJavaEnv to write and update files on the file system.
rJavaEnv needs permission to manage files in your project and cache directories
to function correctly.
}
\details{
In line with \href{https://cran.r-project.org/web/packages/policies.html}{CRAN policies}, explicit user consent is required before making these changes.
Please call \code{rJavaEnv::consent()} to provide consent.

Alternatively, you can set the following \R option
(especially useful for non-interactive R sessions):

\if{html}{\out{<div class="sourceCode">}}\preformatted{options(rJavaEnv.consent = TRUE)
}\if{html}{\out{</div>}}

The function is based on the code of the \code{renv} package.
Copyright 2023 Posit Software, PBC
License: https://github.com/rstudio/renv/blob/main/LICENSE
}
\examples{
\dontrun{

# to provide consent and prevent other functions from interrupting to get the consent
rje_consent(provided = TRUE)
}

}
