% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genoprobs2selfprobs.R
\name{genoprobs2selfprobs}
\alias{genoprobs2selfprobs}
\title{Calculating a set of self QTL effects from conditional genotype probabilities}
\usage{
genoprobs2selfprobs(genoprobs, a1, d1, contrasts = c(TRUE, TRUE, TRUE))
}
\arguments{
\item{genoprobs}{Conditional genotype probabilities as taken from \code{qtl::calc.genoprob()}.}

\item{a1}{A numeric scalar indicating additive deviation.}

\item{d1}{A numeric scalar indicating dominance deviation.}

\item{contrasts}{A vector composed of three TRUE/FALSE values. Depending on the crossing design, it represents the presence/absence of specific genotypes as c(TRUE/FALSE, TRUE/FALSE, TRUE/FALSE) = AA, AB, BB.}
}
\value{
A numeric matrix containing individuals x marker elements for self QTL effects.
}
\description{
A function to reshape \code{qtl}'s object of conditional genotype probabilities, and to calculate self QTL effects for all individuals with given deviation coefficients and conditional genotype probabilities.
}
\author{
Yasuhiro Sato (\email{sato.yasuhiro.36c@kyoto-u.jp})
}
