\name{borderPoint}
\alias{borderPoint}
\title{
Border in the experimental units
}
\description{
Generates the spectral information of the edge of the UEs for analysis of the border effect, it requires the spectral image, the distance of the border and the segmentation of the UEs generated by imageField. 
}
\usage{
borderPoint(r,Rbook,distance,plotting=TRUE,...)
}
\arguments{
  \item{r}{spectral image}
  \item{Rbook}{Object generated by imageField}
  \item{distance}{distance defining the border of the exterior to the experimental plot}
  \item{plotting}{Logic value to display the image of the border effect around the UEs}
  \item{...}{plot parameter to document the image as main, axis, etc}
}
\details{
Set the border in terms of distance in units measured in the field
}
\value{
\item{Qborder}{Border bounds matrix} 
\item{border}{dataframe spectral border and that is expressed in the image.}
}

\author{
Felipe de Mendiburu
}
\seealso{\code{\link{fixedPoint}}, \code{\link{fourPoint}}, \code{\link{imageField}}, 
\code{\link{designRaster}}, \code{\link{movePlot}}}

\examples{
# use corn crop information
library(rPAex)
crop <- system.file("external/corn.csv", package="rPAex")
s<-read.csv(crop,header = TRUE)
r <- raster::rasterFromXYZ(s)
# simulated area
P<-list(x=c(287705.9, 287711.8, 287712.8),y=c(8664203.15, 8664204.8, 8664193.67))
Q<-fourPoint(P)
Rbook<-imageField(r,Q,1,1,0,0,plotting=FALSE)
op<-par(mfrow=c(1,2))
out<-borderPoint(r,Rbook,distance=1, main="Border effect")
par(op)
# NDVI in border
ndvi<-with(out$Border, (L1-L2)/(L1+L2))
plt<-out$Border[ndvi>0.5,1:2]
op<-par(mfrow=c(1,1))
w<-raster::rasterFromXYZ(out$Border)
raster::image(w,useRaster=FALSE)
points(plt,cex=0.8,col=colors()[51],pch=20)
par(op)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
% __ONLY ONE__ keyword per line
\keyword{ design }
\keyword{ dplot }

