% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perform_search.R
\name{perform_search}
\alias{perform_search}
\title{Perform a Search in the RCSB PDB}
\usage{
perform_search(
  search_operator,
  return_type = "ENTRY",
  request_options = NULL,
  return_with_scores = FALSE,
  return_raw_json_dict = FALSE,
  verbosity = TRUE
)
}
\arguments{
\item{search_operator}{An object specifying the search criteria.}

\item{return_type}{A string specifying the type of data to return, defaulting to 'ENTRY'.}

\item{request_options}{Additional options for the search request, default is NULL.}

\item{return_with_scores}{A boolean indicating whether to return search results with scores, default is FALSE.}

\item{return_raw_json_dict}{A boolean indicating whether to return raw JSON response, default is FALSE.}

\item{verbosity}{A boolean flag indicating whether to display verbose messages during execution, default is TRUE.}
}
\value{
The search results, which can vary based on the return type and options specified.
}
\description{
This function facilitates searching the RCSB Protein Data Bank (PDB) using a specified search operator.
It allows various configurations like return type, additional request options, and verbosity control.
}
\examples{
\donttest{
search_operator = InOperator(value=c("Mus musculus", "Homo sapiens"),
attribute="rcsb_entity_source_organism.taxonomy_lineage.name")
return_type = "NON_POLYMER_ENTITY"
results = perform_search(search_operator, return_type)
results
}
}
