% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpraat.R
\name{it.cut}
\alias{it.cut}
\title{it.cut}
\usage{
it.cut(it, tStart = -Inf, tEnd = Inf)
}
\arguments{
\item{it}{IntensityTier object}

\item{tStart}{beginning time of interval to be cut (default -Inf = cut from the tMin of the IntensityTier)}

\item{tEnd}{final time of interval to be cut (default Inf = cut to the tMax of the IntensityTier)}
}
\value{
IntensityTier object
}
\description{
Cut the specified interval from the IntensityTier and preserve time
}
\examples{
it <- it.sample()
it2 <-   it.cut(it,  tStart = 0.3)
it2_0 <- it.cut0(it, tStart = 0.3)
it3 <-   it.cut(it,  tStart = 0.2, tEnd = 0.3)
it3_0 <- it.cut0(it, tStart = 0.2, tEnd = 0.3)
it4 <-   it.cut(it,  tEnd = 0.3)
it4_0 <- it.cut0(it, tEnd = 0.3)
it5 <-   it.cut(it,  tStart = -1, tEnd = 1)
it5_0 <- it.cut0(it, tStart = -1, tEnd = 1)
\dontrun{
it.plot(it)
it.plot(it2)
it.plot(it2_0)
it.plot(it3)
it.plot(it3_0)
it.plot(it4)
it.plot(it4_0)
it.plot(it5)
it.plot(it5_0)
}
}
\seealso{
\code{\link{it.cut0}}, \code{\link{it.read}}, \code{\link{it.plot}}, \code{\link{it.interpolate}}, \code{\link{it.legendre}}, \code{\link{it.legendreSynth}}, \code{\link{it.legendreDemo}}
}
