% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tg.R
\name{tg.duplicateTierMergeSegments}
\alias{tg.duplicateTierMergeSegments}
\title{tg.duplicateTierMergeSegments}
\usage{
tg.duplicateTierMergeSegments(tg, originalInd, newInd = Inf, newTierName,
  pattern, sep = "-")
}
\arguments{
\item{tg}{TextGrid object}

\item{originalInd}{tier index or "name"}

\item{newInd}{new tier index (\code{1} = the first, \code{Inf} = the last [default])}

\item{newTierName}{name of the new tier}

\item{pattern}{merge segments pattern for the new tier (e.g., \code{"he-llo-world"})}

\item{sep}{separator in pattern (default: \code{"-"})}
}
\value{
TextGrid object
}
\description{
Duplicate tier \code{originalInd} and merge segments (according to the pattern) to the new tier with specified index \code{newInd}
(existing tiers are shifted).
Typical use: create new syllable tier from phone tier. It merges phones into syllables according to separators in pattern.
}
\details{
Note 1: there can be segments with empty labels in the original tier (pause), do not specify them in the pattern

Note 2: if there is an segment with empty label in the original tier in the place of separator in the pattern,
        the empty segment is duplicated into the new tier, i.e. at the position of the separator, there may or may not be
        an empty segment, if there is, it is duplicated. And they are not specified in the pattern.

Note 3: if the segment with empty label is not at the position corresponding to separator, it leads to error
        - the part specified in the pattern between separators cannot be split by empty segments

Note 4: beware of labels that appear empty but they are not (space, new line character etc.) - these segments are handled
        as classical non-empty labels. See example - one label is \code{" "}, therefore it must be specified in the pattern.
}
\examples{
tg <- tg.sample()
tg <- tg.removeTier(tg, "syllable")
collapsed <- paste0(tg$phone$label, collapse = "")  # get actual labels
print(collapsed)  # all labels in collapsed form - copy the string, include separators -> pattern
pattern <- "ja:-ci-P\\\\ek-nu-t_so-?u-J\\\\e-la:S- -nej-dP\\\\i:f-naj-deZ-h\\\\ut_S-ku-?a-?a-ta-ma-na:"
tg2 <- tg.duplicateTierMergeSegments(tg, "phone", 1, "syll", pattern, sep = "-")
\dontrun{
tg.plot(tg)
tg.plot(tg2)
}
}
\seealso{
\code{\link{tg.duplicateTier}}, \code{\link{tg.setTierName}}, \code{\link{tg.removeTier}}
}
