% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tg.R
\name{tg.write}
\alias{tg.write}
\title{tg.write}
\usage{
tg.write(tg, fileNameTextGrid, format = "short")
}
\arguments{
\item{tg}{TextGrid object}

\item{fileNameTextGrid}{Output file name}

\item{format}{Output file format (\code{"short"} (default, short text format) or \code{"text"} (a.k.a. full text format))}
}
\description{
Saves TextGrid to the file. TextGrid may contain both interval and point
tiers (\code{tg[[1]]}, \code{tg[[2]]}, \code{tg[[3]]}, etc.). If tier type is not specified in \code{$type},
is is assumed to be \code{"interval"}. If specified, \code{$type} have to be \code{"interval"} or \code{"point"}.
If there is no \code{class(tg)["tmin"]} and \code{class(tg)["tmax"]}, they are calculated as min and max of
all tiers. The file is saved in UTF-8 encoding.
}
\examples{
\dontrun{
tg <- tg.sample()
tg.write(tg, "demo_output.TextGrid")
}
}
\seealso{
\code{\link{tg.read}}, \code{\link{pt.write}}
}
