% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_laps.R
\name{get_laps}
\alias{get_laps}
\title{Retrieve the laps of an activity}
\usage{
get_laps(stoken, id)
}
\arguments{
\item{stoken}{A \code{\link[httr]{config}} object created using the \code{\link{strava_oauth}} function}

\item{id}{numeric for id of the activity with the laps to request}
}
\value{
Data from an API request.
}
\description{
Retrieve the laps of an activity
}
\details{
Requires authentication stoken using the \code{\link{strava_oauth}} function and a user-created API on the strava website.
}
\examples{
\dontrun{
# create authentication token
# requires user created app name, id, and secret from Strava website
stoken <- httr::config(token = strava_oauth(app_name, app_client_id, 
	app_secret, cache = TRUE))

get_laps(stoken, id = 351217692)
}
}
\concept{token}
