/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.parsers.DocumentBuilderFactory;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineXmlCommand;
import org.tigris.subversion.svnclientadapter.commandline.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class CmdLineRemoteDirEntry
extends CmdLineXmlCommand
implements ISVNDirEntry {
    private String path;
    private SVNRevision.Number revision;
    private SVNNodeKind nodeKind;
    private String lastCommitAuthor;
    private Date lastChangedDate;
    private long size;

    protected CmdLineRemoteDirEntry(String string, SVNRevision.Number number, long l, String string2, Date date, SVNNodeKind sVNNodeKind) {
        this.lastCommitAuthor = string2;
        this.lastChangedDate = date;
        this.nodeKind = sVNNodeKind;
        this.path = string;
        this.revision = number;
        this.size = l;
    }

    public static CmdLineRemoteDirEntry[] createDirEntries(byte[] byArray) throws SVNClientException {
        ArrayList<CmdLineRemoteDirEntry> arrayList = new ArrayList<CmdLineRemoteDirEntry>();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            InputSource inputSource = new InputSource(new ByteArrayInputStream(byArray));
            Document document = documentBuilderFactory.newDocumentBuilder().parse(inputSource);
            NodeList nodeList = document.getElementsByTagName("entry");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                String string = node.getAttributes().getNamedItem("kind").getNodeValue();
                Element element = CmdLineRemoteDirEntry.getFirstNamedElement(node, "name");
                if (element == null) {
                    throw new Exception("'name' tag expected under 'entry'");
                }
                String string2 = element.getFirstChild().getNodeValue();
                long l = 0L;
                Element element2 = null;
                if ("file".equals(string)) {
                    element2 = CmdLineRemoteDirEntry.getNextNamedElement(element, "size");
                    if (element2 == null) {
                        throw new Exception("'size' tag expected under 'entry'");
                    }
                    l = Long.parseLong(element2.getFirstChild().getNodeValue());
                } else {
                    element2 = element;
                }
                Element element3 = CmdLineRemoteDirEntry.getNextNamedElement(element2, "commit");
                if (element3 == null) {
                    throw new Exception("'commit' tag expected under 'entry'");
                }
                Node node2 = element3.getAttributes().getNamedItem("revision");
                SVNRevision.Number number = Helper.toRevNum(node2.getNodeValue());
                Element element4 = CmdLineRemoteDirEntry.getFirstNamedElement(element3, "author");
                if (element4 == null) {
                    throw new Exception("'author' tag expected under 'commit'");
                }
                String string3 = element4.getFirstChild().getNodeValue();
                Element element5 = CmdLineRemoteDirEntry.getNextNamedElement(element4, "date");
                if (element5 == null) {
                    throw new Exception("'date' tag expected under 'commit'");
                }
                Date date = Helper.convertXMLDate(element5.getFirstChild().getNodeValue());
                SVNNodeKind sVNNodeKind = SVNNodeKind.UNKNOWN;
                if ("file".equals(string)) {
                    sVNNodeKind = SVNNodeKind.FILE;
                } else if ("dir".equals(string)) {
                    sVNNodeKind = SVNNodeKind.DIR;
                }
                CmdLineRemoteDirEntry cmdLineRemoteDirEntry = new CmdLineRemoteDirEntry(string2, number, l, string3, date, sVNNodeKind);
                arrayList.add(cmdLineRemoteDirEntry);
            }
        }
        catch (Exception exception) {
            throw new SVNClientException(exception);
        }
        return arrayList.toArray(new CmdLineRemoteDirEntry[arrayList.size()]);
    }

    public boolean getHasProps() {
        return false;
    }

    public SVNNodeKind getNodeKind() {
        return this.nodeKind;
    }

    public SVNRevision.Number getLastChangedRevision() {
        return this.revision;
    }

    public Date getLastChangedDate() {
        return this.lastChangedDate;
    }

    public String getLastCommitAuthor() {
        return this.lastCommitAuthor;
    }

    public String getPath() {
        return this.path;
    }

    public long getSize() {
        return this.size;
    }
}

