/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.tigris.subversion.svnant.SvnCommand;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class Status
extends SvnCommand {
    private File path = null;
    private String textStatusProperty = null;
    private String propStatusProperty = null;
    private String revisionProperty = null;
    private String lastChangedRevisionProperty = null;
    private String lastCommitAuthorProperty = null;
    private String urlProperty = null;

    public void execute(ISVNClientAdapter iSVNClientAdapter) throws BuildException {
        this.validateAttributes();
        this.log("Svn : Status");
        Project project = this.getProject();
        try {
            String string;
            ISVNStatus iSVNStatus = iSVNClientAdapter.getSingleStatus(this.path);
            if (this.textStatusProperty != null) {
                project.setProperty(this.textStatusProperty, iSVNStatus.getTextStatus().toString());
            }
            if (this.propStatusProperty != null) {
                project.setProperty(this.propStatusProperty, iSVNStatus.getPropStatus().toString());
            }
            if (this.revisionProperty != null) {
                project.setProperty(this.revisionProperty, iSVNStatus.getRevision().toString());
            }
            if (this.lastChangedRevisionProperty != null) {
                string = iSVNStatus.getLastChangedRevision() == null ? "" : iSVNStatus.getLastChangedRevision().toString();
                project.setProperty(this.lastChangedRevisionProperty, string);
            }
            if (this.lastCommitAuthorProperty != null) {
                string = iSVNStatus.getLastCommitAuthor();
                if (string == null) {
                    string = "";
                }
                project.setProperty(this.lastCommitAuthorProperty, string);
            }
            if (this.urlProperty != null) {
                string = iSVNStatus.getUrl();
                project.setProperty(this.urlProperty, string != null ? string.toString() : "");
            }
        }
        catch (SVNClientException sVNClientException) {
            throw new BuildException("Can't get status of " + this.path, (Throwable)sVNClientException);
        }
    }

    protected void validateAttributes() throws BuildException {
        if (this.path == null) {
            throw new BuildException("path attribute must be set");
        }
    }

    public void setPath(File file) {
        this.path = file;
    }

    public void setTextStatusProperty(String string) {
        this.textStatusProperty = string;
    }

    public void setPropStatusProperty(String string) {
        this.propStatusProperty = string;
    }

    public void setRevisionProperty(String string) {
        this.revisionProperty = string;
    }

    public void setLastChangedRevisionProperty(String string) {
        this.lastChangedRevisionProperty = string;
    }

    public void setLastCommitAuthorProperty(String string) {
        this.lastCommitAuthorProperty = string;
    }

    public void setUrlProperty(String string) {
        this.urlProperty = string;
    }
}

