/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ServerSocketChannel;
import org.python.core.Py;
import org.python.core.io.SocketIOBase;

public class ServerSocketIO
extends SocketIOBase {
    private ServerSocketChannel socketChannel;

    public ServerSocketIO(ServerSocketChannel socketChannel, String mode) {
        super(mode);
        this.socketChannel = socketChannel;
    }

    public int readinto(ByteBuffer buf) {
        this.checkClosed();
        this.checkReadable();
        throw Py.IOError(107, "Socket is not connected");
    }

    public int write(ByteBuffer buf) {
        this.checkClosed();
        this.checkWritable();
        throw Py.IOError(9, "Bad file descriptor");
    }

    public void close() {
        if (this.closed()) {
            return;
        }
        try {
            this.socketChannel.close();
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
        super.close();
    }

    public Channel getChannel() {
        return this.socketChannel;
    }
}

