/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.File;
import java.io.IOException;
import jline.ConsoleReader;
import jline.Terminal;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.util.InteractiveConsole;

public class JLineConsole
extends InteractiveConsole {
    protected ConsoleReader reader;

    public JLineConsole() {
        this(null);
    }

    public JLineConsole(PyObject locals) {
        this(locals, "<stdin>");
        try {
            File historyFile = new File(System.getProperty("user.home"), ".jline-jython.history");
            this.reader.getHistory().setHistoryFile(historyFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public JLineConsole(PyObject locals, String filename) {
        super(locals, filename, true);
        Terminal.setupTerminal();
        try {
            this.reader = new ConsoleReader();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String raw_input(PyObject prompt) {
        String line = null;
        try {
            line = this.reader.readLine(prompt.toString());
        }
        catch (IOException io) {
            throw Py.IOError(io);
        }
        if (line == null) {
            throw Py.EOFError("Ctrl-D exit");
        }
        return line.endsWith("\n") ? line.substring(0, line.length() - 1) : line;
    }
}

