% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbinom_trng.R
\name{rbinom_trng}
\alias{rbinom_trng}
\title{Binomial random numbers via TRNG.}
\usage{
rbinom_trng(n, size, prob, engine = NULL, parallelGrain = 0L)
}
\arguments{
\item{n}{Number of observations.}

\item{size, prob}{Parameters of the distribution, with the same meaning as in
\code{\link{rbinom}}. Note however that only scalar values are
accepted.}

\item{engine}{Optional \link[=TRNG.Engine]{TRNG engine object}; if missing or
\code{NULL}, the current engine controlled via \link{TRNG.Random} is used.}

\item{parallelGrain}{Optional argument controlling the parallel simulation of
random variates (see \sQuote{Parallel Simulation} below for details).}
}
\value{
Numeric vector of random variates generated with the given
  parameters. The length is determined by \code{n}.
}
\description{
Random number generation for the binomial distribution
  using the TRNG C++ library.
}
\section{Parallel Simulation}{
 When a positive value of argument
  \code{parallelGrain} is supplied, random variates are simulated in
  parallel, provided a \emph{parallel} random number \code{engine} is
  selected. This is done using \pkg{\link{RcppParallel}} via
  \code{parallelFor}, which uses the supplied \code{parallelGrain} to control
  the grain size (the number of threads being controlled by
  \code{\link{setThreadOptions}}). The grain size can greatly affect the overhead of
  performing the required \emph{block splitting} \code{jump} operations and
  should be selected carefully. Note that TRNG guarantees the outcome of such
  parallel execution to be equivalent to a purely sequential simulation.
}

\examples{
## generate 10 random variates using the current TRNG engine
rbinom_trng(10, size = 1L, prob = 0.5)

## use a TRNG engine reference class object
r <- yarn2$new()
rbinom_trng(10, size = 1L, prob = 0.5, engine = r)

## generate 100k random variates in parallel, with 2 threads and 100 grain size
TRNGseed(117)
RcppParallel::setThreadOptions(numThreads = 2L)
x_parallel <- rbinom_trng(100e3, size = 1L, prob = 0.5, parallelGrain = 100L)
TRNGseed(117)
x_serial <- rbinom_trng(100e3, size = 1L, prob = 0.5)
identical(x_serial, x_parallel)
}
\seealso{
\code{\link{rbinom}}, \code{\link{TRNG.Engine}},
  \code{\link{TRNG.Random}}.

Other TRNG distributions: \code{\link{rlnorm_trng}},
  \code{\link{rnorm_trng}}, \code{\link{rpois_trng}},
  \code{\link{runif_trng}}
}
\concept{TRNG distributions}
