# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

box_counting <- function(cloud, lowercutoff) {
    .Call(`_rTwig_box_counting`, cloud, lowercutoff)
}

#' @title Generate random colors
#'
#' @description Generates random hex colors
#'
#' @param n number of colors to generate as an integer
#' @return returns a character vector of hexidecimal colors
#'
#' @noRd
#'
generate_random_colors <- function(n) {
    .Call(`_rTwig_generate_random_colors`, n)
}

#' @title Hexidecimal to floating point
#'
#' @description Convert hex colors to floating points between 0-1
#'
#' @param hex_colors character string of hex colors
#' @return returns a character vector of floating point colors
#'
#' @noRd
#'
hex_to_float <- function(hex_colors) {
    .Call(`_rTwig_hex_to_float`, hex_colors)
}

#' @title Convex Hull
#'
#' @description Finds the indexes forming a 2d convex hull of a point cloud
#'
#' @param points a point cloud numeric matrix of x and y values
#' @return integer vector of convex hull point indexes
#'
#' @noRd
#'
convex_hull <- function(points) {
    .Call(`_rTwig_convex_hull`, points)
}

#' @title Convex Hull Area
#'
#' @description Finds area of a 2d convex hull with the Shoelace formula
#'
#' @param points a point cloud numeric matrix of x and y values
#' @return a double of the convex hull area in square meters
#'
#' @noRd
#'
convex_hull_area <- function(points) {
    .Call(`_rTwig_convex_hull_area`, points)
}

#' @title Generate Circle Points
#'
#' @description Generate circular points from n facets
#'
#' @param center cylinder center
#' @param radius cylinder radius
#' @param facets number of cylinder facets
#' @return Numeric Matrix
#'
#' @noRd
#'
generate_circle_points <- function(center, radius, facets) {
    .Call(`_rTwig_generate_circle_points`, center, radius, facets)
}

#' @title Rotate Circle Points
#'
#' @description Rotate circle points along an axis
#'
#' @param points circle points
#' @param start cylinder start point
#' @param axis cylinder axis
#' @return Numeric Matrix
#'
#' @noRd
#'
rotate_circle_points <- function(points, start, axis) {
    .Call(`_rTwig_rotate_circle_points`, points, start, axis)
}

#' @title Generate Mesh
#'
#' @description Generate mesh vertices to visualize cylinder
#'
#' @param start cylinder starts
#' @param axis cylinder axes
#' @param length cylinder length
#' @param radius cylinder radius
#' @param facets number of cylinder facets
#' @return Numeric Matrix
#'
#' @noRd
#'
generate_mesh <- function(start, axis, length, radius, facets) {
    .Call(`_rTwig_generate_mesh`, start, axis, length, radius, facets)
}

#' @title Generate Cloud
#'
#' @description Generates a synthetic point cloud from QSM cylinder attributes
#'
#' @param start n x 3 matrix containing the x, y, z cylinder start points
#' @param axis n x 3 matrix containing the x, y, z cylinder axis directions
#' @param tips n x 3 matrix containing the x, y, z cylinder end points
#' @param length vector containing the cylinder lengths
#' @param radius vector containing the cylinder radii
#' @param branch vector containing the cylinder branch ids
#' @return n x 3 point cloud matrix
#'
#' @noRd
#'
generate_cloud <- function(start, axis, tips, length, radius, branch) {
    .Call(`_rTwig_generate_cloud`, start, axis, tips, length, radius, branch)
}

#' @title Cross Product
#'
#' @description Calculates the cross product of two vectors
#'
#' @param a first vector
#' @param b second vector
#' @return cross product of a and b
#'
#' @noRd
#'
cross_product <- function(a, b) {
    .Call(`_rTwig_cross_product`, a, b)
}

#' @title Norm
#'
#' @description Calculates the norm of a 1 x 3 vector
#'
#' @param x vector x with size 1 x 3
#' @return norm of vector x
#'
#' @noRd
#'
norm <- function(x) {
    .Call(`_rTwig_norm`, x)
}

#' @title Orthonormal Vectors
#'
#' @description Generates vectors V and W that are unit vectors orthogonal to
#' themselves and to the input vector U
#'
#' @param U input vector
#' @return list containing vectors V and W
#'
#' @noRd
#'
orthonormal_vectors <- function(U) {
    .Call(`_rTwig_orthonormal_vectors`, U)
}

#' @title Rotation matrix
#'
#' @description Returns the rotation matrix for the given axis A and angle
#'
#' @param A vector of size 1 x 3
#' @param angle angle in radians
#' @return rotation matrix
#'
#' @noRd
#'
rotation_matrix <- function(A, angle) {
    .Call(`_rTwig_rotation_matrix`, A, angle)
}

#' @title Matrix Vector Subtraction
#'
#' @description Subtract a vector in a matrix
#'
#' @param A matrix of dimensions n x n
#' @param v vector with dimensions 1 x n
#' @return matrix
#'
#' @noRd
#'
mat_vec_subtraction <- function(A, v) {
    .Call(`_rTwig_mat_vec_subtraction`, A, v)
}

#' @title Matrix Multiplication
#'
#' @description Subtract a matrix by a matrix
#'
#' @param A matrix of dimensions n x n
#' @param B vector with dimensions n x n
#' @return matrix
#'
#' @noRd
#'
mat_multiplication <- function(A, B) {
    .Call(`_rTwig_mat_multiplication`, A, B)
}

#' @title Index Order
#'
#' @description Get order of sorted vector indexes
#'
#' @param v vector with dimensions 1 x n
#' @return integer vector
#'
#' @noRd
#'
index_order <- function(x) {
    .Call(`_rTwig_index_order`, x)
}

#' @title Sort Index
#'
#' @description Sort a vector by a specified order
#'
#' @param v vector with dimensions 1 x n
#' @param indexes integer vector with desired ordering
#' @return vector
#'
#' @noRd
#'
sort_index <- function(x, indexes) {
    .Call(`_rTwig_sort_index`, x, indexes)
}

#' @title Connect Cylinders
#'
#' @description Connects cylinder endpoints and smooths axes
#'
#' @param branch_position position in the branch
#' @param branch branch id
#' @param start x x start
#' @param start y y start
#' @param start z z start
#' @param axis x x axis
#' @param axis y y axis
#' @param axis z z axis
#' @param end x x end
#' @param end y y end
#' @param end z z end
#' @return n x 3 point cloud matrix
#'
#' @noRd
#'
connect_cylinders <- function(cylinder) {
    invisible(.Call(`_rTwig_connect_cylinders`, cylinder))
}

