% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wcvp_distribution.R
\name{wcvp_distribution}
\alias{wcvp_distribution}
\title{Generate spatial distribution objects for species, genera or families}
\usage{
wcvp_distribution(
  taxon,
  taxon_rank = c("species", "genus", "family", "order", "higher"),
  native = TRUE,
  introduced = TRUE,
  extinct = TRUE,
  location_doubtful = TRUE,
  wcvp_names = NULL,
  wcvp_distributions = NULL
)
}
\arguments{
\item{taxon}{Character. The taxon to be mapped. Must be provided.}

\item{taxon_rank}{Character. One of "species", "genus", "family", "order" or "higher", giving the rank of the value in \code{taxon}.}

\item{native}{Logical. Include native range? Defaults to \code{TRUE}.}

\item{introduced}{Logical. Include introduced range? Defaults to \code{TRUE}.}

\item{extinct}{Logical. Include extinct range? Defaults to \code{TRUE}.}

\item{location_doubtful}{Logical. Include occurrences that are thought to be
doubtful? Defaults to \code{TRUE}.}

\item{wcvp_names}{A data frame of taxonomic names from WCVP version 7 or later.
If \code{NULL} (the default), names will be loaded from \href{https://matildabrown.github.io/rWCVPdata/}{\code{rWCVPdata::wcvp_names}}.}

\item{wcvp_distributions}{A data frame of distributions from WCVP version 7 or later.
If \code{NULL} (the default), distributions will be loaded from \href{https://matildabrown.github.io/rWCVPdata/}{\code{rWCVPdata::wcvp_names}}.}
}
\value{
Simple features (\code{sf}) data frame containing the range polygon/s of the taxon.
}
\description{
Generate spatial distribution objects for species, genera or families
}
\details{
Where \code{taxon_rank} is higher than species, the distribution of the whole
group will be returned, not individual species within that group. This also applies when
toggling options - for example, introduced occurrences will only be included if they are
outside the native range, regardless of whether \code{native=TRUE} or \code{native=FALSE}.
To identify extinctions, introductions or doubtful occurrences within the native range,
the \code{wcvp_summary} and \code{wcvp_occ_mat} functions can be used.
}
\examples{
\donttest{ # this example requires 'rWCVPdata'
if(requireNamespace("rWCVPdata")){
r <- wcvp_distribution("Callitris", taxon_rank = "genus")
p <- wcvp_distribution_map(r)
p
}
}
}
