\name{wind.fit}
\alias{wind.fit}

\title{
Wind-data fit
}
\description{
wind.fit is used to transform a data.frame obtained from wind.dl. wind.fit applies trigonometry tools to transform U and V vector wind components in wind direction and speed features. It also transforms 0-360 longitude notation obtained from GFS data into -180/180 longitude notation to be used in GIS (Geographic Information Systems) or R plotting. Moreover, it cleans column names obtained from wind.dl, deletes "time" column and sorts the data by latitude.
}
\usage{
wind.fit(X)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{X}{data.frame generated by wind.dl function from rWind package.
}
}

\value{
A data.frame prepared to be plotted by R or to be exported as a CSV file to be used with a GIS software.
}
\references{
https://en.wikipedia.org/wiki/Cross_product
}
\author{
Javier Fernández-López (jflopez@rjb.csic.es)
}
\note{
If you want to calculate wind average from multiple wind datasets using wind.mean function, you should use U and V vector components rather than speed and direction values. Please, perform the calculations through wind.mean directly from the result of wind.dl function before of running wind.fit
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
wind.dl, wind.mean, wind2raster
}
\examples{
# Download wind for Spain region at 2015, November 2, 00:00
X <- wind.dl(2015,11,2,0,-10,5,35,45)

# Fit downloaded dataset to be plotted
wind_data <- wind.fit(X)

# Export as CSV format in your work directory
write.csv(wind_data, "wind_data_2015_11_2_Spain.csv")
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~wind }
\keyword{ ~gfs }% __ONLY ONE__ keyword per line
