% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wind_functions2.R
\name{flow.dispersion_int}
\alias{flow.dispersion_int}
\title{Compute flow-based cost or conductance}
\usage{
flow.dispersion_int(stack, type = "passive", output = "raw")
}
\arguments{
\item{stack}{RasterStack object with layers obtained from wind2raster
function ("rWind" package) with direction and speed flow values.}

\item{type}{Could be either "passive" or "active".In "passive" mode,
movement against flow direction is not allowed (deviations from the wind
direction higher than 90). In "active" mode, the movement can go against flow
direction, by increasing the cost.}

\item{output}{This argument allows to select diferent kinds of output. "raw"
mode creates a matrix (class "dgCMatrix") with transition costs between all
cells in the raster. "transitionLayer" creates a TransitionLayer object with
conductance values to be used with "gdistance" package.}
}
\value{
In "transitionLayer" output, the function returns conductance values
(1/cost)to move betwen all cells in a raster having into account flow speed
and direction obtained from wind.fit function("rWind" package). As wind or
sea currents implies directionality, flow.dispersion produces an anisotropic
conductance matrix (asimetric). Conductance values are used later to built a
TransitionLayer object from "gdistance" package.

In "raw" output, flow.dispersion creates a sparse Matrix with cost values.
}
\description{
flow.dispersion_int computes movement conductance through a flow either, sea or
wind currents. It implements the formula described in Felícisimo et al.
2008:
}
\details{
Cost=(1/Speed)*(HorizontalFactor)

being HorizontalFactor a "function that incrementaly penalized angular
deviations from the wind direction" (Felicísimo et al. 2008).
}
\note{
Note that for large data sets, it could take a while. For large study
areas is strongly adviced perform the analysis in a remote computer or a
cluster.
}
\examples{

data(wind.data)
wind <- wind2raster(wind.data)
Conductance<-flow.dispersion(wind,"passive", "transitionLayer")

\dontrun{
require(gdistance)
transitionMatrix(Conductance)
image(transitionMatrix(Conductance))
}
}
\references{
Felicísimo, Á. M., Muñoz, J., & González-Solis, J. (2008). Ocean surface
winds drive dynamics of transoceanic aerial movements. PLoS One, 3(8),
e2928.

Jacob van Etten (2017). R Package gdistance: Distances and Routes on
Geographical Grids. Journal of Statistical Software, 76(13), 1-21.
doi:10.18637/jss.v076.i13
}
\seealso{
\code{\link{wind.dl}}, \code{\link{wind2raster}}
}
\author{
Javier Fernández-López; Klaus Schliep
}
\keyword{internal}
\keyword{~anisotropy}
\keyword{~conductance}
