% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wind_functions2.R
\name{seaScud.dl}
\alias{seaScud.dl}
\title{SCUD Sea currents data download}
\usage{
seaScud.dl(yyyy, mm, dd, lon1, lon2, lat1, lat2, type = "read-data",
  trace = 1)
}
\arguments{
\item{yyyy}{Selected year.}

\item{mm}{Selected month.}

\item{dd}{Selected day.}

\item{lon1}{Western longitude}

\item{lon2}{Eastern longitude}

\item{lat1}{Southern latitude}

\item{lat2}{Northern latitude}

\item{type}{Output type. "read-data" is selected by default, creating an R
object. If you choose "csv", seaOscar.dl create a a CSV file in your working
directory named "seaSCUD_yyyy_mm_dd.csv".}

\item{trace}{if trace = 1 (by default) track downloaded files}
}
\value{
"rWind" and "data.frame" class object or .csv file with U and V
vector  components and sea current direction and speed for each coordenate
in the study area defined by lon1/lon2 and lat1/lat2.
}
\description{
seaScud.dl downloads sea current data from the Surface CUrrents from a
Diagnostic model (SCUD): Pacific
(https://bluehub.jrc.ec.europa.eu/erddap/info/hawaii_0958_63c0_45d2/index.html).
Geospatial resolution is 0.25 degrees. Data availability from 2012-03-17 to
current.
}
\details{
The output type is determined by type="csv" or type="read-data". If
type="csv" is selected, the function creates a "sea_yyyy_mm_dd.csv" file
that is downloaded at the work directory. If type="read-data" is selected,
an R object (data.frame) is created.
}
\examples{

# Download sea currents for Galapagos Islands
\dontrun{

seaScud.dl(2016, 11, 1, -94, -88, -3, 2)

}
}
\references{
http://www.digital-geography.com/cloud-gis-getting-weather-data/#.WDOWmbV1DCL

https://bluehub.jrc.ec.europa.eu/erddap/info/hawaii_0958_63c0_45d2/index.html
}
\seealso{
\code{\link{seaOscar.dl}}, \code{\link{wind2raster}}
}
\author{
Javier Fernández-López (jflopez@rjb.csic.es)
}
\keyword{~currents}
\keyword{~sea}
