% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{nonReliableVGenes}
\alias{nonReliableVGenes}
\title{Detect non reliable gene assignment}
\usage{
nonReliableVGenes(clip_db, thresh = 0.9, appearance = 0.01)
}
\arguments{
\item{clip_db}{a \code{data.frame} in AIRR format. See details.}

\item{thresh}{the threshold to consider non reliable gene. Default is 0.9}

\item{appearance}{the minimum fraction of gene appearance to be considered for reliability check. Default is 0.01.}
}
\value{
a nested list of non reliable genes for all subject.
}
\description{
\code{nonReliableVGenes} Takes a \code{data.frame} in AIRR format  and detect non reliable IGHV genes. A non reliable gene is
when the ratio of the multiple assignments with a gene is below the threshold.
}
\details{
The function accepts a \code{data.frame} in AIRR format (\url{https://changeo.readthedocs.io/en/stable/standard.html}) containing the following columns:
\itemize{
  \item \code{'subject'}: subject names
  \item \code{'v_call'}: V allele call(s) (in an IMGT format)
}
}
\examples{
# Example IGHV call data frame
clip_db <- data.frame(subject=rep('S1',6),
v_call=c('IGHV1-69*01','IGHV1-69*01','IGHV1-69*01,IGHV1-69*02',
'IGHV4-59*01,IGHV4-61*01','IGHV4-59*01,IGHV4-31*02','IGHV4-59*01'))
# Detect non reliable genes
nonReliableVGenes(clip_db)
}
