% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radarBoxplot.R
\name{radarBoxplot}
\alias{radarBoxplot}
\alias{radarBoxplot.default}
\alias{radarBoxplot.formula}
\title{Function to plot the radar-boxplot}
\usage{
radarBoxplot(x, ...)

\method{radarBoxplot}{formula}(x, data, ...)

\method{radarBoxplot}{default}(x, y, plot.median = FALSE,
  use.ggplot2 = TRUE, mfrow = NA, col = c("red", "blue"),
  oma = c(5, 4, 0, 0) + 0.1, mar = c(0, 0, 1, 1) + 0.1, ...)
}
\arguments{
\item{x}{a data frame or matrix of attributes or a formula describing the
attributes for the class}

\item{...}{optional parameters to be passed to the function `radarBoxplot.default`}

\item{data}{dataset for fomula variant for which formula was defined}

\item{y}{a response vector}

\item{plot.median}{boolean value to flag if median should be plotted, defaults to FALSE}

\item{use.ggplot2}{if ggplot2, data.table and dplyr are available it will use ggplot for plotting. defaults to TRUE}

\item{mfrow}{mfrow argument for defining the subplots nrows and ncols}

\item{col}{the colors to use for radar-boxplot, first color is the percentile 25-75\%
second is the total range and third color is the color for median line}

\item{oma}{outer margins of the subplots}

\item{mar}{margins of the subplots}
}
\description{
Function to plot the radar-boxplot
}
\examples{
library(radarBoxplot)
data("winequality_red")

# Regular
radarBoxplot(quality ~ ., winequality_red)

# Orange and green pattern with grey median
radarBoxplot(quality ~ ., winequality_red,
             use.ggplot2=FALSE, plot.median=TRUE,
             col=c("orange", "green", "grey"))

# Plot in 2 rows and 3 columns
# change columns order (counter clockwise)
radarBoxplot(quality ~ volatile.acidity + alcohol + sulphates + pH +
             density + total.sulfur.dioxide + free.sulfur.dioxide +
             chlorides + residual.sugar + citric.acid, winequality_red,
             use.ggplot2=FALSE, plot.median=FALSE,
             col=c("red", "blue"), mfrow=c(2, 3))

}
