% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_tabs.R
\name{cross_tabs}
\alias{cross_tabs}
\title{Evaluate associations between categorical variables}
\usage{
cross_tabs(dataset, var1, var2, data_filter = "")
}
\arguments{
\item{dataset}{Dataset name (string). This can be a dataframe in the global environment or an element in an r_data list from Radiant}

\item{var1}{A categorical variable}

\item{var2}{Another categorical variable}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}
}
\value{
A list of all variables used in cross_tabs as an object of class cross_tabs
}
\description{
Evaluate associations between categorical variables
}
\details{
See \url{https://radiant-rstats.github.io/docs/basics/cross_tabs.html} for an example in Radiant
}
\examples{
result <- cross_tabs("newspaper", "Income", "Newspaper")
result <- newspaper \%>\% cross_tabs("Income", "Newspaper")

}
\seealso{
\code{\link{summary.cross_tabs}} to summarize results

\code{\link{plot.cross_tabs}} to plot results
}
