% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conjoint.R
\name{the_table}
\alias{the_table}
\title{Function to calculate the PW and IW table for conjoint}
\usage{
the_table(model, dat, evar)
}
\arguments{
\item{model}{Tidied model results (broom) output from \code{\link{conjoint}} passed on by summary.conjoint}

\item{dat}{Conjoint data}

\item{evar}{Explanatory variables used in the conjoint regression}
}
\description{
Function to calculate the PW and IW table for conjoint
}
\details{
See \url{https://radiant-rstats.github.io/docs/multivariate/conjoint.html} for an example in Radiant
}
\examples{
result <- conjoint(dataset = "mp3", rvar = "Rating", evar = "Memory:Shape")
the_table(result$model, result$dat, result$evar)

}
\seealso{
\code{\link{conjoint}} to generate results

\code{\link{summary.conjoint}} to summarize results

\code{\link{plot.conjoint}} to plot results
}

