% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/em.R
\name{fFixEm}
\alias{fFixEm}
\title{EM when f is fixed}
\usage{
fFixEm(gnew, qnew, f, acc, max.iter, tol = 1e-4, pubdata)
}
\arguments{
\item{gnew}{Genotype matrix. The number of row present in gnew is 1 and the number
of column is the number of SNPs.}

\item{qnew}{Initial q used in calculation. A vector. sum(q) must be 1.}

\item{f}{Allele frequencies learned from the reference panels.}

\item{acc}{a logical value indicating whether use quasi-Newton accelerated EM or not.}

\item{max.iter}{an integer. If acc is TRUE, the number of iterations must be set.
max.iter should greater than 1.}

\item{tol}{Tolerance. If acc is FALSE, tol must be set. The default is 1e-4.}

\item{pubdata}{You can choose a public dataset here, E11, K13, K4, K12b, K7b, World9. You also can use other public
dataset which is not in this package.}
}
\value{
Estimation results of q and the loglikelihood value of each iteration.
}
\description{
This function can be used for ancestry analysis when frequency matrix is fixed.
}
