\name{evaluateSfit}
\alias{evaluateSfit}
\title{
Visual inspection of the fit of a regularized precision matrix
}
\description{
Function aiding the visual inspection of the fit of an estimated (possibly regularized) precision matrix vis-a-vis the 
sample covariance matrix. 
}
\usage{
evaluateSfit(Phat, S, diag = FALSE, fileType = "pdf", nameExt = "", dir = getwd())
}
\arguments{
  \item{Phat}{
(Regularized) estimate of the precision \code{matrix}.
}
  \item{S}{
Sample covariance \code{matrix}
}
  \item{diag}{
A \code{logical} determining if the diagonal elements should be retained for plotting.
}
  \item{fileType}{
A \code{character} determining the output file type. Must be one of: "pdf", "eps". 
}
  \item{nameExt}{
A \code{character} determining the extension of default output names generated by the function.           
}
  \item{dir}{
A \code{character} specifying the directory in which the visual output is stored.
}
}
\details{
The function outputs various visualizations to aid the visual inspection of an estimated and possibly regularized
precision matrix vis-a-vis the sample covariance matrix. The inverse of the estimated precision matrix \code{P} is taken
to represent the estimated covariance matrix. The function then outputs a QQ-plot and a heatmap of the observed covariances 
against the estimated ones. The heatmap has the estimated covariances as lower-triangular elements and the observed covariances
as the upper-triangular elements. The function outputs analogous plots for the estimated and observed correlations. In case the
observed covariance matrix \code{S} is non-singular also a QQ-plot an a heatmap are generated for the estimated and observed 
partial correlations. 

The function generates files with extension \code{fileType} under default output names. These files are stored in the directory 
\code{dir} (default is the working directory). To avoid overwriting of files when working in a single directory one may employ 
the argument \code{nameExt}. By using \code{nameExt} the default output names are extended with a character of choice.
}
\author{
Wessel N. van Wieringen, Carel F.W. Peeters <cf.peeters@vumc.nl>
}
\seealso{
\code{\link{ridgeS}}, \code{\link{covML}}
}
\examples{
\dontrun{
## Obtain some (high-dimensional) data
p = 25
n = 10
set.seed(333)
X = matrix(rnorm(n*p), nrow = n, ncol = p)
colnames(X)[1:25] = letters[1:25]
Cx <- covML(X)

## Obtain regularized precision matrix
P <- ridgeS(Cx, lambda = 10, type = 'Alt')

## Evaluate visually fit of regularized precision matrix vis-a-vis sample covariance
evaluateSfit(P, Cx, diag = FALSE, fileType = "pdf", nameExt = "test")}
}