/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.datastream.filereaders.arffFileReader;

import eu.amidst.core.datastream.Attribute;
import eu.amidst.core.datastream.Attributes;
import eu.amidst.core.datastream.filereaders.DataFileReader;
import eu.amidst.core.datastream.filereaders.DataRow;
import eu.amidst.core.datastream.filereaders.arffFileReader.DataRowWeka;
import eu.amidst.core.variables.StateSpaceType;
import eu.amidst.core.variables.StateSpaceTypeEnum;
import eu.amidst.core.variables.stateSpaceTypes.FiniteStateSpace;
import eu.amidst.core.variables.stateSpaceTypes.RealStateSpace;
import eu.amidst.core.variables.stateSpaceTypes.SparseFiniteStateSpace;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class ARFFDataReader
implements DataFileReader {
    String relationName;
    private Attributes attributes;
    private int dataLineCount;
    private Path pathFile;
    private StateSpaceTypeEnum[] stateSpace;
    private Stream<DataRow> streamString;

    public static Attribute createAttributeFromLine(int index, String line) {
        String[] parts = line.split("\\s+|\t+");
        if (!parts[0].trim().startsWith("@attribute")) {
            throw new IllegalArgumentException("Attribute line does not start with @attribute");
        }
        String name = parts[1].trim();
        name = name.replaceAll("^'+", "");
        name = name.replaceAll("'+$", "");
        parts[2] = parts[2].trim();
        if (parts[2].equals("real") || parts[2].equals("numeric")) {
            if (parts.length > 3 && parts[3].startsWith("[")) {
                parts[3] = line.substring(line.indexOf("[")).replaceAll("\t", "");
                double min = Double.parseDouble(parts[3].substring(parts[3].indexOf("[") + 1, parts[3].indexOf(",")));
                double max = Double.parseDouble(parts[3].substring(parts[3].indexOf(",") + 1, parts[3].indexOf("]")));
                return new Attribute(index, name, new RealStateSpace(min, max));
            }
            return new Attribute(index, name, new RealStateSpace());
        }
        if (parts[2].startsWith("{")) {
            parts[2] = line.substring(line.indexOf("{")).replaceAll("\t", "");
            String[] states = parts[2].substring(1, parts[2].length() - 1).split(",");
            List<String> statesNames = Arrays.stream(states).map(String::trim).collect(Collectors.toList());
            return new Attribute(index, name, new FiniteStateSpace(statesNames));
        }
        if (parts[2].equals("SparseMultinomial")) {
            return new Attribute(index, name, new SparseFiniteStateSpace(Integer.parseInt(parts[3])));
        }
        throw new UnsupportedOperationException("We can not create an attribute from this line: " + line);
    }

    @Override
    public void loadFromFile(String pathString) {
        this.pathFile = Paths.get(pathString, new String[0]);
        try {
            Optional<String> atRelation = Files.lines(this.pathFile).map(String::trim).filter(w -> !w.isEmpty()).filter(w -> !w.startsWith("%")).limit(1L).filter(line -> line.startsWith("@relation")).findFirst();
            if (!atRelation.isPresent()) {
                throw new IllegalArgumentException("ARFF file does not start with a @relation line.");
            }
            this.relationName = atRelation.get().split(" ")[1];
            int[] count = new int[]{0};
            Optional<String> atData = Files.lines(this.pathFile).map(String::trim).filter(w -> !w.isEmpty()).filter(w -> !w.startsWith("%")).peek(line -> {
                count[0] = count[0] + 1;
            }).filter(line -> line.startsWith("@data")).findFirst();
            if (!atData.isPresent()) {
                throw new IllegalArgumentException("ARFF file does not contain @data line.");
            }
            this.dataLineCount = count[0];
            List attLines = Files.lines(this.pathFile).map(String::trim).filter(w -> !w.isEmpty()).filter(w -> !w.startsWith("%")).limit(this.dataLineCount).filter(line -> line.startsWith("@attribute")).collect(Collectors.toList());
            List<Attribute> atts = IntStream.range(0, attLines.size()).mapToObj(i -> ARFFDataReader.createAttributeFromLine(i, (String)attLines.get(i))).collect(Collectors.toList());
            this.attributes = new Attributes(atts);
            this.stateSpace = new StateSpaceTypeEnum[atts.size()];
            for (Attribute att : atts) {
                this.stateSpace[att.getIndex()] = ((StateSpaceType)att.getStateSpaceType()).getStateSpaceTypeEnum();
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean doesItReadThisFile(String fileName) {
        if (new File(fileName).isDirectory()) {
            return false;
        }
        String[] parts = fileName.split("\\.");
        return parts[parts.length - 1].equals("arff");
    }

    @Override
    public Stream<DataRow> stream() {
        try {
            this.streamString = Files.lines(this.pathFile).filter(w -> !w.isEmpty()).filter(w -> !w.startsWith("%")).skip(this.dataLineCount).filter(w -> !w.isEmpty()).map(line -> new DataRowWeka(this.attributes, (String)line));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return this.streamString;
    }

    @Override
    public void restart() {
        this.streamString = null;
    }
}

