/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.exponentialfamily;

import eu.amidst.core.distribution.UnivariateDistribution;
import eu.amidst.core.exponentialfamily.EF_UnivariateDistribution;
import eu.amidst.core.exponentialfamily.SufficientStatistics;
import eu.amidst.core.utils.ArrayVector;
import eu.amidst.core.utils.Utils;
import eu.amidst.core.utils.Vector;
import eu.amidst.core.variables.Variable;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.math3.special.Gamma;

public class EF_InverseGamma
extends EF_UnivariateDistribution {
    public static final int LOGX = 0;
    public static final int INVX = 1;
    public static final double DELTA = 1.0E-4;

    public EF_InverseGamma(Variable var1) {
        if (!var1.isInverseGammaParameter()) {
            throw new IllegalArgumentException("The variable is not Inverse Gamma parameter");
        }
        this.parents = new ArrayList();
        this.var = var1;
        this.naturalParameters = this.createZeroNaturalParameters();
        this.momentParameters = this.createZeroMomentParameters();
        this.naturalParameters.set(0, -2.1);
        this.naturalParameters.set(1, -1.0);
        this.setNaturalParameters(this.naturalParameters);
    }

    @Override
    public double computeLogBaseMeasure(double val) {
        return 0.0;
    }

    @Override
    public SufficientStatistics getSufficientStatistics(double val) {
        SufficientStatistics vec = this.createZeroSufficientStatistics();
        vec.set(0, Math.log(val));
        vec.set(1, 1.0 / val);
        return vec;
    }

    @Override
    public EF_UnivariateDistribution deepCopy(Variable var) {
        EF_InverseGamma copy = new EF_InverseGamma(var);
        copy.getNaturalParameters().copy(this.getNaturalParameters());
        copy.getMomentParameters().copy(this.getMomentParameters());
        return copy;
    }

    @Override
    public EF_UnivariateDistribution randomInitialization(Random random) {
        double alpha = random.nextGaussian() * 2.0 + 1.0;
        double beta = random.nextDouble() * 1.0 + 0.1;
        this.getNaturalParameters().set(0, -alpha - 1.0);
        this.getNaturalParameters().set(1, -beta);
        this.fixNumericalInstability();
        this.updateMomentFromNaturalParameters();
        return this;
    }

    @Override
    public <E extends UnivariateDistribution> E toUnivariateDistribution() {
        throw new UnsupportedOperationException("Inverse Gamma is not included yet in the Distributions package.");
    }

    @Override
    public void updateNaturalFromMomentParameters() {
        double m0 = this.getMomentParameters().get(0);
        double m1 = this.getMomentParameters().get(1);
        double newalpha = 2.0;
        double alpha = 0.0;
        double newbeta = 2.0;
        double beta = 0.0;
        while (Math.abs(newalpha - alpha) > 1.0E-4 || Math.abs(newbeta - beta) > 1.0E-4) {
            alpha = newalpha;
            beta = newbeta;
            newalpha = Utils.invDigamma(Math.log(beta) - m0);
            newbeta = newalpha / m1;
        }
        this.naturalParameters.set(0, newalpha);
        this.naturalParameters.set(1, newbeta);
    }

    @Override
    public void updateMomentFromNaturalParameters() {
        double alpha = -this.naturalParameters.get(0) - 1.0;
        double beta = -this.naturalParameters.get(1);
        this.momentParameters.set(0, Math.log(beta) - Gamma.digamma(alpha));
        this.momentParameters.set(1, alpha / beta);
    }

    @Override
    public int sizeOfSufficientStatistics() {
        return 2;
    }

    @Override
    public double computeLogNormalizer() {
        double alpha = -this.naturalParameters.get(0) - 1.0;
        double beta = -this.naturalParameters.get(1);
        return Gamma.logGamma(alpha) - alpha * Math.log(beta);
    }

    @Override
    public Vector createZeroVector() {
        return new ArrayVector(2);
    }

    @Override
    public Vector getExpectedParameters() {
        ArrayVector vec = new ArrayVector(1);
        vec.set(0, -this.naturalParameters.get(1) / (-this.naturalParameters.get(0) - 1.0));
        return vec;
    }

    @Override
    public void fixNumericalInstability() {
    }

    @Override
    public SufficientStatistics createInitSufficientStatistics() {
        ArrayVector vector = new ArrayVector(this.sizeOfSufficientStatistics());
        double alpha = 1.0;
        double beta = 1.0;
        vector.set(0, Math.log(beta) - Gamma.digamma(alpha));
        vector.set(1, alpha / beta);
        return vector;
    }
}

