/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.learning.parametric.bayesian.utils;

import eu.amidst.core.datastream.DataInstance;
import eu.amidst.core.exponentialfamily.EF_ConditionalDistribution;
import eu.amidst.core.exponentialfamily.EF_Distribution;
import eu.amidst.core.exponentialfamily.EF_LearningBayesianNetwork;
import eu.amidst.core.exponentialfamily.EF_UnivariateDistribution;
import eu.amidst.core.exponentialfamily.MomentParameters;
import eu.amidst.core.exponentialfamily.NaturalParameters;
import eu.amidst.core.inference.messagepassing.Node;
import eu.amidst.core.inference.messagepassing.VMP;
import eu.amidst.core.models.DAG;
import eu.amidst.core.utils.CompoundVector;
import eu.amidst.core.utils.Vector;
import eu.amidst.core.variables.DistributionType;
import eu.amidst.core.variables.Variable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class PlateuStructure
implements Serializable {
    private static final long serialVersionUID = 4107783324901370839L;
    protected Map<Variable, Boolean> replicatedVariables = new HashMap<Variable, Boolean>();
    protected transient List<Node> nonReplictedNodes = new ArrayList<Node>();
    protected transient List<List<Node>> replicatedNodes = new ArrayList<List<Node>>();
    protected EF_LearningBayesianNetwork ef_learningmodel;
    protected int nReplications = 100;
    protected VMP vmp = new VMP();
    protected transient Map<Variable, Node> nonReplicatedVarsToNode = new ConcurrentHashMap<Variable, Node>();
    protected transient List<Map<Variable, Node>> replicatedVarsToNode = new ArrayList<Map<Variable, Node>>();
    protected List<Variable> initialNonReplicatedVariablesList = new ArrayList<Variable>();
    protected List<Variable> nonReplicatedVariablesList;

    public PlateuStructure() {
    }

    public PlateuStructure(List<Variable> initialNonReplicatedVariablesList) {
        this.initialNonReplicatedVariablesList.addAll(initialNonReplicatedVariablesList);
    }

    public void initTransientDataStructure() {
        this.replicatedVarsToNode = new ArrayList<Map<Variable, Node>>();
        this.nonReplicatedVarsToNode = new ConcurrentHashMap<Variable, Node>();
        this.replicatedNodes = new ArrayList<List<Node>>();
        this.nonReplictedNodes = new ArrayList<Node>();
    }

    public Stream<Node> getNonReplictedNodes() {
        return this.nonReplictedNodes.stream();
    }

    public Stream<Node> getReplicatedNodes() {
        return this.replicatedNodes.stream().flatMap(l -> l.stream());
    }

    public int getNumberOfReplications() {
        return this.nReplications;
    }

    public VMP getVMP() {
        return this.vmp;
    }

    public void setVmp(VMP vmp) {
        this.vmp = vmp;
    }

    public void resetQs() {
        this.vmp.resetQs();
    }

    public void setSeed(int seed) {
        this.vmp.setSeed(seed);
    }

    public EF_LearningBayesianNetwork getEFLearningBN() {
        return this.ef_learningmodel;
    }

    public void setDAG(DAG dag) {
        List<EF_ConditionalDistribution> dists = dag.getParentSets().stream().map(pSet -> ((DistributionType)pSet.getMainVar().getDistributionType()).newEFConditionalDistribution(pSet.getParents())).collect(Collectors.toList());
        this.ef_learningmodel = new EF_LearningBayesianNetwork(dists, this.initialNonReplicatedVariablesList);
        this.ef_learningmodel.getListOfParametersVariables().stream().forEach(var -> this.replicatedVariables.put((Variable)var, false));
        this.ef_learningmodel.getListOfNonParameterVariables().stream().forEach(var -> this.replicatedVariables.put((Variable)var, true));
        this.initialNonReplicatedVariablesList.stream().forEach(var -> this.replicatedVariables.put((Variable)var, false));
        this.nonReplicatedVariablesList = this.replicatedVariables.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(entry -> (Variable)entry.getKey()).sorted((a, b) -> a.getVarID() - b.getVarID()).collect(Collectors.toList());
    }

    private void setVariableAsNonReplicated(Variable var) {
        this.replicatedVariables.put(var, false);
    }

    private void setVariableAsReplicated(Variable var) {
        this.replicatedVariables.put(var, true);
    }

    public List<Variable> getNonReplicatedVariables() {
        return this.nonReplicatedVariablesList;
    }

    public List<Variable> getReplicatedVariables() {
        return this.replicatedVariables.entrySet().stream().filter(entry -> (Boolean)entry.getValue()).map(entry -> (Variable)entry.getKey()).sorted((a, b) -> a.getVarID() - b.getVarID()).collect(Collectors.toList());
    }

    public void setNRepetitions(int nRepetitions_) {
        this.nReplications = nRepetitions_;
    }

    public void runInference() {
        this.vmp.runInference();
    }

    public double getLogProbabilityOfEvidence() {
        return this.vmp.getLogProbabilityOfEvidence();
    }

    public Node getNodeOfVar(Variable variable, int slice) {
        if (this.isNonReplicatedVar(variable)) {
            return this.nonReplicatedVarsToNode.get(variable);
        }
        return this.replicatedVarsToNode.get(slice).get(variable);
    }

    public <E extends EF_UnivariateDistribution> E getEFParameterPosterior(Variable var) {
        if (!this.nonReplicatedVariablesList.contains(var) && !var.isParameterVariable()) {
            throw new IllegalArgumentException("Only non replicated variables or parameters can be queried");
        }
        return (E)this.nonReplicatedVarsToNode.get(var).getQDist();
    }

    public <E extends EF_UnivariateDistribution> E getEFVariablePosterior(Variable var, int slice) {
        if (this.nonReplicatedVariablesList.contains(var) || var.isParameterVariable()) {
            throw new IllegalArgumentException("Only replicated variables can be queried");
        }
        return (E)this.getNodeOfVar(var, slice).getQDist();
    }

    public abstract void replicateModel();

    public abstract void setEvidence(List<? extends DataInstance> var1);

    public Node getNodeOfNonReplicatedVar(Variable variable) {
        if (this.isNonReplicatedVar(variable)) {
            return this.nonReplicatedVarsToNode.get(variable);
        }
        throw new IllegalArgumentException("This variable is a replicated var.");
    }

    public boolean isNonReplicatedVar(Variable var) {
        return this.replicatedVariables.get(var) == false;
    }

    public boolean isReplicatedVar(Variable var) {
        return this.replicatedVariables.get(var);
    }

    public CompoundVector getPlateauNaturalParameterPrior() {
        List<Vector> naturalPlateauParametersPriors = this.ef_learningmodel.getDistributionList().stream().map(dist -> dist.getVariable()).filter(var -> this.isNonReplicatedVar((Variable)var)).map(var -> {
            NaturalParameters parameter = ((EF_Distribution)this.ef_learningmodel.getDistribution((Variable)var)).getNaturalParameters();
            NaturalParameters copy = ((EF_Distribution)this.ef_learningmodel.getDistribution((Variable)var)).createZeroNaturalParameters();
            copy.copy(parameter);
            return copy;
        }).collect(Collectors.toList());
        return new CompoundVector(naturalPlateauParametersPriors);
    }

    public CompoundVector getPlateauNaturalParameterPosterior() {
        List<Vector> naturalPlateauParametersPriors = this.ef_learningmodel.getDistributionList().stream().map(dist -> dist.getVariable()).filter(var -> this.isNonReplicatedVar((Variable)var)).map(var -> {
            EF_UnivariateDistribution qDist = this.getNodeOfNonReplicatedVar((Variable)var).getQDist();
            NaturalParameters parameter = qDist.getNaturalParameters();
            NaturalParameters copy = qDist.createZeroNaturalParameters();
            copy.copy(parameter);
            return copy;
        }).collect(Collectors.toList());
        return new CompoundVector(naturalPlateauParametersPriors);
    }

    public CompoundVector getPlateauMomentParameterPosterior() {
        List<Vector> momentPlateauParametersPriors = this.ef_learningmodel.getDistributionList().stream().map(dist -> dist.getVariable()).filter(var -> this.isNonReplicatedVar((Variable)var)).map(var -> {
            EF_UnivariateDistribution qDist = this.getNodeOfNonReplicatedVar((Variable)var).getQDist();
            MomentParameters parameter = qDist.getMomentParameters();
            MomentParameters copy = qDist.createZeroMomentParameters();
            copy.copy(parameter);
            return copy;
        }).collect(Collectors.toList());
        return new CompoundVector(momentPlateauParametersPriors);
    }

    public void updateNaturalParameterPosteriors(CompoundVector parameterVector) {
        int[] count = new int[]{0};
        this.ef_learningmodel.getDistributionList().stream().map(dist -> dist.getVariable()).filter(var -> this.isNonReplicatedVar((Variable)var)).forEach(var -> {
            EF_UnivariateDistribution uni = this.getNodeOfNonReplicatedVar((Variable)var).getQDist();
            uni.getNaturalParameters().copy(parameterVector.getVectorByPosition(count[0]));
            uni.fixNumericalInstability();
            uni.updateMomentFromNaturalParameters();
            count[0] = count[0] + 1;
        });
    }

    public void updateNaturalParameterPrior(CompoundVector parameterVector) {
        int[] count = new int[]{0};
        this.ef_learningmodel.getDistributionList().stream().map(dist -> dist.getVariable()).filter(var -> this.isNonReplicatedVar((Variable)var)).forEach(var -> {
            EF_UnivariateDistribution uni = this.getNodeOfNonReplicatedVar((Variable)var).getQDist().deepCopy();
            uni.getNaturalParameters().copy(parameterVector.getVectorByPosition(count[0]));
            uni.fixNumericalInstability();
            uni.updateMomentFromNaturalParameters();
            this.ef_learningmodel.setDistribution((Variable)var, uni);
            this.getNodeOfNonReplicatedVar((Variable)var).setPDist(uni);
            count[0] = count[0] + 1;
        });
    }

    public void desactiveParametersNodes() {
        this.ef_learningmodel.getParametersVariables().getListOfParamaterVariables().stream().forEach(var -> this.getNodeOfNonReplicatedVar((Variable)var).setActive(false));
    }

    public void activeParametersNodes() {
        this.ef_learningmodel.getParametersVariables().getListOfParamaterVariables().stream().forEach(var -> this.getNodeOfNonReplicatedVar((Variable)var).setActive(true));
    }

    public double getPosteriorSampleSize() {
        return Double.NaN;
    }
}

