/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.utils;

import eu.amidst.core.datastream.DataInstance;
import eu.amidst.core.datastream.DataStream;
import eu.amidst.core.utils.BayesianNetworkGenerator;
import eu.amidst.core.utils.BayesianNetworkSampler;

public final class DataSetGenerator {
    public static DataStream<DataInstance> generate(int seed, int nSamples, int nDiscreteAtts, int nContinuousAttributes) {
        BayesianNetworkGenerator.setSeed(seed);
        BayesianNetworkGenerator.setNumberOfGaussianVars(nContinuousAttributes);
        BayesianNetworkGenerator.setNumberOfMultinomialVars(nDiscreteAtts, 2);
        int nTotal = nDiscreteAtts + nContinuousAttributes;
        int nLinksMin = nTotal - 1;
        int nLinksMax = nTotal * (nTotal - 1) / 2;
        BayesianNetworkGenerator.setNumberOfLinks((int)(0.8 * (double)nLinksMin + 0.2 * (double)nLinksMax));
        BayesianNetworkSampler sampler = new BayesianNetworkSampler(BayesianNetworkGenerator.generateBayesianNetwork());
        sampler.setSeed(seed);
        return sampler.sampleToDataStream(nSamples);
    }
}

